# -*- coding: utf-8 -*-

import sandbox.common.types.client as ctc

from sandbox.projects.common.build.YaMake import YaMakeTask
from sandbox.projects.common.nanny import nanny

import sandbox.projects.common.build.parameters as build_params

import sandbox.projects.ugc.resources as resources


class BuildUgcViewer(YaMakeTask, nanny.ReleaseToNannyTask):
    """
        Build UGC viewer
    """

    type = 'BUILD_UGC_VIEWER'
    client_tags = ctc.Tag.Group.LINUX
    cores = 24

    input_parameters = [
        build_params.ArcadiaUrl,
        build_params.ArcadiaPatch,
        build_params.DefinitionFlags,
    ]

    def get_targets(self):
        return [
            'entity/ugc/tools/viewer_server/bin',
            'entity/ugc/tools/viewer_server/files',
        ]

    def get_arts(self):
        return [
            {'path': 'entity/ugc/tools/viewer_server/bin/viewer_server'},
        ]

    def get_arts_source(self):
        return [
            {'path': 'entity/ugc/tools/viewer_server/files'},
        ]

    def get_resources(self):
        project = {}
        project['resource_type'] = resources.UgcViewer
        project['description'] = 'UGC viewer files'
        project['resource_path'] = ''
        return {'project': project}

    def on_release(self, additional_parameters):
        nanny.ReleaseToNannyTask.on_release(self, additional_parameters)
        YaMakeTask.on_release(self, additional_parameters)


__Task__ = BuildUgcViewer
