from sandbox import sdk2
from sandbox.sandboxsdk import process
from sandbox.sdk2.service_resources import SandboxTasksBinary
from sandbox.projects.app_host import resources as app_host_resources

import json


class UgcDbHttpAmmo(sdk2.Resource):
    """File with http ammo for UGC DB in phantom format"""


class UgcDbApphostAmmo(sdk2.Resource):
    """File with apphost ammo for UGC Db"""


class UgcDbApphostContext(sdk2.Resource):
    """File with apphost context for generating ammo for UGC Db"""


class PrepareUgcDbAmmo(sdk2.Task):
    """Prepares ammos for load test of UGC DB using it's access log"""

    class Parameters(sdk2.Task.Parameters):
        access_log_path = sdk2.parameters.String(
            "Path to directory with UGC DB access logs",
            default="//logs/ugc-db-access-log/1d",
            required=True)

        log_tables_count = sdk2.parameters.Integer("Number of log tables to use", default=1, required=True)

        ammo_count = sdk2.parameters.Integer("Number of ammos", default=1000000, required=True)

        yt_proxy = sdk2.parameters.String("YT cluster where logs are located", default="hahn", required=True)

        yt_token_vault_name = sdk2.parameters.String("Name of Vault var with YT token", default="robot-ugc-oncall-yt-token", required=True)

        make_ammo = sdk2.parameters.Resource(
            "app_host_tool_make_tank_ammo executable",
            resource_type=app_host_resources.APP_HOST_TOOL_MAKE_TANK_AMMO_EXECUTABLE,
            default_value=705329126,
            required=True)

    def on_save(self):
        self.Requirements.tasks_resource = SandboxTasksBinary.find(
            attrs={
                'target': 'ugc/release_quality/ammo_generator',  # set this attr when uploading new version on task runner
            }
        ).first().id

    def on_execute(self):
        import entity.ugc.tests.lib.ammo as make_ammo
        import yt.wrapper as yt

        yt_token = sdk2.Vault.data(self.Parameters.yt_token_vault_name)
        client = yt.YtClient(proxy=self.Parameters.yt_proxy, token=yt_token)
        with client.TempTable() as tmp_table, client.TempTable() as tmp_contexts:
            make_ammo.generate_ugcdb_ammo(self.Parameters.access_log_path, tmp_table, tmp_contexts, self.Parameters.log_tables_count, client)

            rows = 0

            apphost_contexts = sdk2.ResourceData(UgcDbApphostContext(self, "apphost context for UGC", "context.txt"))
            with apphost_contexts.path.open(mode='wb') as context:
                for row in client.read_table(tmp_contexts, format="json"):
                    context.write(json.dumps(row))
                    context.write("\n")
                    rows += 1
                    if rows * 2 >= self.Parameters.ammo_count:
                        break
            apphost_contexts.ready()

            apphost_ammo = sdk2.ResourceData(UgcDbApphostAmmo(self, "apphost ammo for UGC", "apphost_ammo.txt"))
            process.run_process("{} -i {} -o {}".format(
                str(sdk2.ResourceData(self.Parameters.make_ammo).path),
                str(apphost_contexts.path),
                str(apphost_ammo.path),
            ), shell=True)

            apphost_ammo.ready()

            ammo_resource = sdk2.ResourceData(UgcDbHttpAmmo(self, "UGC DB ammo", "ammo.txt"))
            with ammo_resource.path.open(mode='wb') as ammo:
                for row in client.read_table(tmp_table, format=yt.YsonFormat()):
                    ammo.write(row["ammo"])
                    rows += 1
                    if rows == self.Parameters.ammo_count:
                        break
            ammo_resource.ready()
