from sandbox import sdk2
from sandbox.sandboxsdk import environments


class UgcServerHttpAmmo(sdk2.Resource):
    """File with http ammo for UGC server in phantom format"""


class UgcServerApphostAmmo(sdk2.Resource):
    """File with apphost ammo for UGC server in phantom format"""


class PrepareUgcServerAmmo(sdk2.Task):
    """Prepares ammos for load test of UGC server using it's access log"""

    class Requirements(sdk2.Requirements):
        environments = (
            environments.PipEnvironment("yandex-yt"),
            environments.PipEnvironment("yandex-yt-yson-bindings-skynet")
        )

    class Parameters(sdk2.Task.Parameters):
        access_log_path = sdk2.parameters.String(
            "Path to directory with UGC server access logs",
            default="//logs/ugc-server-access-log/1d",
            required=True)

        log_tables_count = sdk2.parameters.Integer("Number of log tables to use", default=1, required=True)

        ammo_count = sdk2.parameters.Integer("Number of ammos", default=1000000, required=True)

        yt_proxy = sdk2.parameters.String("YT cluster where logs are located", default="hahn", required=True)

        yt_token_vault_name = sdk2.parameters.String("Name of Vault var with YT token", default="robot-ugcdb-yt-token", required=True)

    def on_execute(self):
        from . import yt_runner
        import yt.wrapper as yt

        yt_token = sdk2.Vault.data(self.Parameters.yt_token_vault_name)
        client = yt.YtClient(proxy=self.Parameters.yt_proxy, token=yt_token)
        with client.TempTable() as tmp_table:
            yt_runner.run(
                self.Parameters.yt_proxy,
                yt_token,
                self.Parameters.access_log_path,
                self.Parameters.log_tables_count,
                tmp_table
            )

            ammo_resource = sdk2.ResourceData(UgcServerHttpAmmo(self, "UGC server ammo", "ammo.txt"))
            with ammo_resource.path.open(mode='wb') as ammo:
                rows = 0
                for row in client.read_table(tmp_table, format=yt.JsonFormat(attributes={"encode_utf8": False})):
                    ammo.write(row["ammo"].encode("utf-8"))
                    rows += 1
                    if rows == self.Parameters.ammo_count:
                        break
            ammo_resource.ready()
