from sandbox import sdk2
import sandbox.sdk2.parameters as sb_parameters
from sandbox.sdk2.service_resources import SandboxTasksBinary

import logging
import requests


class UgcServerFunctionalTest(sdk2.Task):
    """
        Runs UGC server functional tests
    """

    class Parameters(sdk2.Parameters):
        with sb_parameters.RadioGroup("Binary release type") as ReleaseType:
            ReleaseType.values.stable = ReleaseType.Value('stable', default=True)
            ReleaseType.values.test = ReleaseType.Value('test')

    def on_save(self):
        self.Requirements.tasks_resource = SandboxTasksBinary.find(
            attrs={
                'target': 'ugc/release_quality/test_runner',  # set this attr when uploading new version on task runner
                'release': self.Parameters.ReleaseType or 'stable'
            }
        ).first().id

    def on_execute(self):
        logging.info("ping test server")
        r = requests.get('http://ugc-test.n.yandex-team.ru/ping')
        r.raise_for_status()
        logging.info("ping done successfully!")
