from __future__ import absolute_import

from sandbox import sdk2

CORE_TEAM = [
    'bartimaeous',
    'bochkarev',
    'denisbykov',
    'evsluzh',
    'fyodor',
    'ivannik',
    'livshits199',
    'mikailbag',
    'qqq',
    'ovarene',
    'pitnails',
    'riariorovere',
    'skazhenik',
    'vanayp',
    'zador',
    'zhvv117',
    'ksburaya',
    'karavashkin',
]

ROBOTS = [
    'robot-ugcdb',
    'robot-ugcdb-test',
    'robot-testenv',
]


class BusinessDetailedUgcRatings(sdk2.Resource):
    """
        Directory resource with unpacked and cooked reviews exported from UGC robot to be used at geosearch rating calculation
    """
    auto_backup = True
    releasable = True
    releasers = CORE_TEAM + ROBOTS


class UgcComponentBase(sdk2.Resource):
    """
        Base resource for all ugc components
    """
    releasable = True
    any_arch = False
    auto_backup = True
    releasers = CORE_TEAM + ROBOTS


class UgcServerExecutable(UgcComponentBase):
    """
        Executable for UGC server
    """
    executable = True


class UgcDbBackendExecutable(UgcComponentBase):
    """
        Executable for UGC DB Backend
    """
    executable = True


class UgcAlligatorExecutable(UgcComponentBase):
    """
        Executable for UGC Alligator (aka Fast Robot)
    """
    executable = True


class UgcFeederExecutable(UgcComponentBase):
    """
        Executable for UGC Feeder (aka Fast Robot)
    """
    executable = True


class BellServerExecutable(UgcComponentBase):
    """
        Executable for bell server
    """
    executable = True


class UgcComponentServerConfigDir(UgcComponentBase):
    """
        Config dir for all ugcserver executables
    """
    any_arch = True
    executable = False


class UgcRobot(sdk2.Resource):
    """
        UGC robot files
    """
    releasable = True
    any_arch = False
    releasers = CORE_TEAM + ROBOTS
    release_subscribers = CORE_TEAM


class UgcNotificationSender(sdk2.Resource):
    """
        UGC robot files
    """
    releasable = True
    any_arch = False
    releasers = CORE_TEAM + ROBOTS
    release_subscribers = CORE_TEAM


class UgcNotificationSender2(sdk2.Resource):
    """
        UGC robot files
    """
    releasable = True
    any_arch = False
    releasers = CORE_TEAM + ROBOTS
    release_subscribers = CORE_TEAM


class UgcNewsReactionAggr(sdk2.Resource):
    """
        UGC robot files
    """
    releasable = True
    any_arch = False
    releasers = CORE_TEAM + ROBOTS
    release_subscribers = CORE_TEAM


class UgcDbPypiPackage(sdk2.Resource):
    """
        UGC DB pypi package
    """
    releasable = True
    any_arch = False
    releasers = CORE_TEAM + ROBOTS
    release_subscribers = CORE_TEAM


class UgcViewer(sdk2.Resource):
    """
        UGC viewer files
    """
    releasable = True
    any_arch = False
    releasers = CORE_TEAM + ROBOTS
    release_subscribers = CORE_TEAM


class PortoLayerUgcHomeTrusty(sdk2.Resource):
    """
        Porto layer for tools&libraries&etc for service instances
    """
    releasable = True
    releasers = CORE_TEAM + ROBOTS
