# -*- coding: utf-8 -*-
from sandbox import sdk2
import sandbox.common.types.client as ctc
from sandbox.projects.common.build.tasks import YaMakeTemplate
from sandbox.projects.common.ya_deploy import release_integration

from ..resources import BaseResource


class UsRtStageBinary(BaseResource):
    __abstract__ = True
    executable = True
    releasable = True
    auto_backup = True
    any_arch = False


class ANTIROBOT_US_RT_BINARY(UsRtStageBinary):
    arcadia_build_path = 'quality/user_sessions/rt/processors/antirobot'


class BAOBAB_ENRICH_PARTIAL_US_RT_BINARY(UsRtStageBinary):
    arcadia_build_path = 'quality/user_sessions/rt/processors/baobab_enrich_partial'


class BAOBAB_ENRICH_PARTIAL_TURBO_US_RT_BINARY(UsRtStageBinary):
    arcadia_build_path = 'quality/user_sessions/rt/processors/baobab_enrich_partial_turbo'


class DROP_PREFETCHES_US_RT_BINARY(UsRtStageBinary):
    arcadia_build_path = 'quality/user_sessions/rt/processors/drop_prefetches'


class IMAGES_REDUCER_US_RT_BINARY(UsRtStageBinary):
    arcadia_build_path = 'quality/user_sessions/rt/processors/images_reducer'


class KPI_US_RT_BINARY(UsRtStageBinary):
    arcadia_build_path = 'quality/user_sessions/rt/processors/kpi'


class POST_RESHARDER_US_RT_BINARY(UsRtStageBinary):
    arcadia_build_path = 'quality/user_sessions/rt/processors/post_resharder'


class REDUCER_US_RT_BINARY(UsRtStageBinary):
    arcadia_build_path = 'quality/user_sessions/rt/processors/reducer'


class RESHARDER_US_RT_BINARY(UsRtStageBinary):
    arcadia_build_path = 'quality/user_sessions/rt/processors/resharder'


class TEST_LOGS_US_RT_BINARY(UsRtStageBinary):
    arcadia_build_path = 'quality/user_sessions/rt/processors/test_logs'


class VIDEO_REDUCER_US_RT_BINARY(UsRtStageBinary):
    arcadia_build_path = 'quality/user_sessions/rt/processors/video_reducer'


class YT_TO_LB_US_RT_BINARY(UsRtStageBinary):
    arcadia_build_path = 'quality/user_sessions/rt/processors/yt_to_lb'


class QUEUE_DAEMON_US_RT_BINARY(UsRtStageBinary):
    arcadia_build_path = 'ads/bsyeti/big_rt/queue_daemon'


class TABLE_BALANCER_US_RT_BINARY(UsRtStageBinary):
    arcadia_build_path = 'quality/user_sessions/rt/tools/table_balancer'


class SOLOMON_AGENT_US_RT_BINARY(UsRtStageBinary):
    arcadia_build_path = 'solomon/agent/bin'


class BuildRustBinaries(YaMakeTemplate.YaMakeTemplate, release_integration.ReleaseToYaDeployTask):
    class Requirements(sdk2.Task.Requirements):
        client_tags = ctc.Tag.Group.LINUX
        disk_space = 2048  # 1Gb

    class Parameters(
        YaMakeTemplate.get_project_params(
            [
                ANTIROBOT_US_RT_BINARY,
                BAOBAB_ENRICH_PARTIAL_US_RT_BINARY,
                BAOBAB_ENRICH_PARTIAL_TURBO_US_RT_BINARY,
                DROP_PREFETCHES_US_RT_BINARY,
                IMAGES_REDUCER_US_RT_BINARY,
                POST_RESHARDER_US_RT_BINARY,
                RESHARDER_US_RT_BINARY,
                REDUCER_US_RT_BINARY,
                VIDEO_REDUCER_US_RT_BINARY,
                KPI_US_RT_BINARY,
                YT_TO_LB_US_RT_BINARY,
                TEST_LOGS_US_RT_BINARY,
                TABLE_BALANCER_US_RT_BINARY,
                QUEUE_DAEMON_US_RT_BINARY,
                SOLOMON_AGENT_US_RT_BINARY,
            ]
        )
    ):
        pass

    def on_release(self, additional_parameters):
        release_integration.ReleaseToYaDeployTask.on_release(self, additional_parameters)
        YaMakeTemplate.YaMakeTemplate.on_release(self, additional_parameters)
