# -*- coding: utf-8 -*-

from sandbox import sdk2


HUMAN_RELEASERS = [
    'sinister',
    'kender',
    'ngc224',
    'gavrgavr',
    'mmatrosova',
    'zsafiullin',
    'kkhamitov',
    'shadowgorn',
    'dalamar',
    'exoron',
    'statizarm',
]

ROBOT_RELEASERS = [
    'robot-rust-releaser',
    'robot-make-money',
]

GROUP_RELEASERS = [
    'RELEASE_MACHINE',
]

RELEASERS = HUMAN_RELEASERS + ROBOT_RELEASERS + GROUP_RELEASERS

DEFAULT_RESOURCE_TTL = 7


class BaseResource(sdk2.Resource):
    __abstract__ = True

    releasers = RELEASERS
    ttl = DEFAULT_RESOURCE_TTL


class US_RT_DEPLOY_TOOL(BaseResource):
    executable = True


class US_RT_RESOURCES_SPEC(BaseResource):
    pass


class US_RT_MISC(BaseResource):
    pass


class US_RT_STAGE_CONFIG(BaseResource):
    auto_backup = True
    releasable = True


class US_RT_BINARIES(BaseResource):
    auto_backup = True
    releasable = True


class US_RT_CONFIGS(BaseResource):
    auto_backup = True
    releasable = True


class US_RT_DATA_FILES(BaseResource):
    auto_backup = True
    releasable = True
