# -*- coding: utf-8 -*-

from sandbox import sdk2


USERFEAT_RELEASERS = ['USERFEAT']


class UserfeatReleasableBase(sdk2.Resource):
    releasable = True
    releasers = USERFEAT_RELEASERS


class PORTO_LAYER_USERFEAT_CM(UserfeatReleasableBase):
    """
    Porto layer with ClusterMaster dependencies for User Features

    The name prefix "PORTO_LAYER_" is required by build process
    """
    pass


class UserfeatYtMetadata(sdk2.Resource):
    """
    JSON file with metadata from YT Cypress
    """
    pass


class UserfeatCommonBinariesRelease(UserfeatReleasableBase):
    """
    User Features binaries to deploy via Nanny

    At the moment the resource consists of merged content of main Debian packages.
    Later we are going to skip the Debian package step and avoid any compression.
    """
    source_resource_ids = sdk2.Attributes.String("Resource IDs of source Debian packages")


class UserfeatBrowseBinariesRelease(UserfeatReleasableBase):
    """See UserfeatCommonBinariesRelease description"""
    source_resource_ids = sdk2.Attributes.String("Resource IDs of source Debian packages")


class UserfeatCountersBinariesRelease(UserfeatReleasableBase):
    """See UserfeatCommonBinariesRelease description"""
    source_resource_ids = sdk2.Attributes.String("Resource IDs of source Debian packages")


class UserfeatSearchBinariesRelease(UserfeatReleasableBase):
    """See UserfeatCommonBinariesRelease description"""
    source_resource_ids = sdk2.Attributes.String("Resource IDs of source Debian packages")


class UserfeatMiscBinariesRelease(UserfeatReleasableBase):
    """See UserfeatCommonBinariesRelease description"""
    source_resource_ids = sdk2.Attributes.String("Resource IDs of source Debian packages")


class UserfeatUserdataBinariesRelease(UserfeatReleasableBase):
    """See UserfeatCommonBinariesRelease description"""
    source_resource_ids = sdk2.Attributes.String("Resource IDs of source Debian packages")


class UserfeatFastUserdataBinariesRelease(UserfeatReleasableBase):
    pass


class UserfeatWebmasterBinariesRelease(UserfeatReleasableBase):
    pass


class UserfeatCmpyCommon(UserfeatReleasableBase):
    """
    User Features Common CMPY binaries
    """
    pass


class UserfeatCmpyMiscdata(UserfeatReleasableBase):
    """
    User Features Miscdata CMPY binaries
    """
    pass


class UserfeatCmpyUserdata(UserfeatReleasableBase):
    """
    User Features Userdata CMPY binaries
    """
    pass


class UserfeatCmpyFastUserdata(UserfeatReleasableBase):
    """
    User Features Fast Userdata CMPY binaries
    """
    pass


class UserfeatCmpyUserCounters(UserfeatReleasableBase):
    """
    User Features UserCounters CMPY binaries
    """
    pass


class UserfeatCmpyUserSearch(UserfeatReleasableBase):
    """
    User Features UserSearch CMPY binaries
    """
    pass


class UserfeatCmpyUserBrowse(UserfeatReleasableBase):
    """
    User Features UserBrowse CMPY binaries
    """
    pass


class UserfeatCmpyWebmaster(UserfeatReleasableBase):
    """
    Webmaster CMPY binaries to run in User Features
    """
    pass


class UserfeatDataRelease(UserfeatReleasableBase):
    """
    Bundled data resources for User Features release:
    - geodata5.bin
    - ipreg
    - geoa.c2p
    - blockstat.dict
    - rfl, directory containing filter.rfl and filter.robots.rfl
    - keys.json
    """
    source_resource_ids = sdk2.Attributes.String("Resource IDs of source data")


class UserfeatMrappsRelease(UserfeatReleasableBase):
    """
    Bundled minimal set of mrapps binaries
    """
    pass


class UserfeatViewers(UserfeatReleasableBase):
    """
    Userfeat viewers binaries
    - nest
    - yt_vivisector
    """
    pass


class UserfeatYuppieInputTables(sdk2.Resource):
    """
    Input tables for tests. Yson tables and their description in data_spec.json file
    """
    pass
