# -*- coding: utf-8 -*-

from sandbox import sdk2

verstehen_releasers = ['artemkorenev']
paskills_verstehen_releasers = ['0442a403', 'ivangromov', 'kuptservol', 'pazus', 'robot-paskills-yt']


class VERSTEHEN_SERVER_EXECUTABLE(sdk2.Resource):
    """
    Package for Verstehen executable app
    """
    releasable = True
    any_arch = True
    executable = True
    auto_backup = True
    releasers = verstehen_releasers


class VERSTEHEN_APP_BUCKET(sdk2.Resource):
    """
    Package for data with texts and indexes files to launch an app on Verstehen server
    """
    releasable = True
    any_arch = True
    executable = False
    auto_backup = True
    releasers = verstehen_releasers


class PASKILLS_VERSTEHEN_APP_BUCKET(sdk2.Resource):
    """
    Package for data with texts and indexes files grouped by skill_id to launch an app
    on Verstehen server for external skills
    """
    releasable = True
    any_arch = True
    executable = False
    auto_backup = True
    releasers = paskills_verstehen_releasers
