#!/usr/bin/env python
# -*- coding: utf-8 -*-

import json
import logging
import time
import requests


MICROSECONDS = 1000000

KV_SAAS_DATA_YT_SERVER_SHORT = "arnold"
KV_SAAS_DATA_YT_SERVER_LONG = "arnold.yt.yandex.net"

KV_SAAS_UPPER_UPLOAD_URL = 'http://querydata.ferryman.n.yandex-team.ru'
KV_SAAS_FAST_UPPER_UPLOAD_URL = 'http://fast-query-data.ferryman.n.yandex-team.ru'


def upload_trie_to_saas(saas_url,
                        namespace, namespace_suffix,
                        yt_token_file, yt_input_table,
                        yt_cluster=KV_SAAS_DATA_YT_SERVER_SHORT,
                        timestamp=int(time.time()) * MICROSECONDS,
                        delta=False, nomirror=False):
    import yt.wrapper as yt
    yt_token = open(yt_token_file).read().strip()
    yt_client = yt.YtClient(proxy=yt_cluster, token=yt_token)

    if delta and not yt_client.exists(yt_input_table):
        return

    saas_namespace = namespace
    if namespace_suffix:
        namespace += ":{}".format(namespace_suffix)

    tables = [{
        'Path': yt_input_table,
        'Namespace': saas_namespace,
        'Timestamp': timestamp,
        'Delta': delta,
        'Cluster': yt_cluster}]

    params = {'tables': json.dumps(tables)}
    if nomirror:
        params['nomirror'] = 'true'

    resp = requests.get(saas_url + '/add-full-tables', params=params)
    if not resp.ok:
        raise requests.RequestException(
            "url: '%s', status_code: %s, text: '%s'" % (resp.url, str(resp.status_code), resp.text))

    logging.info('upload_trie_to_saas: url=%s, status_code=%s, resp=%s' % (
        resp.url, str(resp.status_code), str(resp.json())
    ))


def upload_trie_to_yt_table(input_file, yt_output_table, yt_token_file,
                            yt_server=KV_SAAS_DATA_YT_SERVER_LONG,
                            key_name="Subkey_StructKey", value_name="Data_JSON"):
    import yt.wrapper as yt
    yt_token = open(yt_token_file).read().strip()
    yt_client = yt.YtClient(proxy=yt_server, token=yt_token)

    rows = []
    with open(input_file) as f:
        for line in f:
            key = line.split("\t", 1)[0]
            value = line.split("\t", 1)[1]
            rows.append({key_name: key, value_name: value})
    yt_client.write_table(yt_output_table, rows)
