import json
import time
import requests

from sandbox import sdk2

from sandbox.common.errors import TaskFailure


class MonitorTvFastData(sdk2.Task):
    class Parameters(sdk2.Task.Parameters):
        pass

    def get_resource_id(self):
        svn_url = sdk2.svn.Arcadia.trunk_url('/search/web/rearrs_upper/rearrange.fast/tv_broadcast')
        svn_dir = sdk2.svn.Arcadia.get_arcadia_src_dir(svn_url)
        svn_dir = str(svn_dir)

        filename = svn_dir + "/ya.make"
        with open(filename, 'r') as file:
            for line in file:
                if 'tv_shows_for_fast' in line:
                    return line[18:-24]

    def get_resource_expire_time(self, resource_id):
        resource = sdk2.ResourceData(sdk2.Resource.find(id=resource_id).first())
        with open(str(resource.path)) as f:
            data = json.loads('\n'.join(f.readlines()))
        finish_times = []
        for channel_data in data["tv_shows"].values():
            if len(channel_data.get("shows", [])) == 0:
                continue
            last_time = 0
            for show in channel_data["shows"]:
                if show["finish"] > last_time:
                    last_time = show["finish"]
            finish_times.append(last_time)
        idx = int(0.3 * len(finish_times))
        return sorted(finish_times)[idx]

    def get_solomon_data(self, remaining_time):
        return {
            "commonLabels": {
                "project": "freshness",
                "cluster": "prod",
                "service": "verticals",
            },
            "sensors": [
                {
                    "labels": {
                        "sensor": "remaining_tv_time",
                    },
                    "value": remaining_time,
                },
            ]
        }

    def on_execute(self):
        resource_id = self.get_resource_id()
        remaining_time = self.get_resource_expire_time(resource_id) - int(time.time())
        solomon_data = self.get_solomon_data(remaining_time)
        print (solomon_data)
        result = requests.post("http://api.solomon.search.yandex.net/push/json", headers={'Content-Type': 'application/json'}, data=json.dumps(solomon_data))
        if result.status_code != 200:
            raise TaskFailure('Failed to push data to solomon: code {}'.format(result.status_code))
