# -*- coding: utf-8 -*-

import os
import sandbox.common.types.task as ctt

from sandbox import common
from sandbox import sdk2
import sandbox.projects.resource_types.releasers as resource_releasers

VH_BACKEND_PATH = "yabs/vh/cms-pgaas"
PACKAGE_PATH = os.path.join(VH_BACKEND_PATH, "samogon/package.json")

BUILD_TASKS_COUNT = 2


class BuildVhBackendPgaasDumbResource(sdk2.Resource):
    """
        Crutch for vh backend build task
    """
    releasers = resource_releasers.vh_backend_releasers
    releasable = True


class BuildVhBackendPgaas(sdk2.Task):
    """
        Build VH Backend
    """

    class Requirements(sdk2.Requirements):
        privileged = True
        execution_space = 50 * 1024  # 50 GB
        required_ram = 4 * 1024

    class Parameters(sdk2.Parameters):
        arcadia_url = sdk2.parameters.ArcadiaUrl(
            "Arcadia url",
            required=True,
        )
        version = sdk2.parameters.String(
            "Custom package version",
            required=True,
        )
        test_issue = sdk2.parameters.String(
            "Test ticket to post tests result to",
            required=True,
        )

    def on_execute(self):
        version = self.Parameters.version
        with self.memoize_stage.build_packages:
            tasks_to_wait = []

            ya_package_task = sdk2.Task["YA_PACKAGE"]
            tasks_to_wait.append(
                ya_package_task(
                    self,
                    description="Build VH Backend web services {version}".format(version=version),
                    packages=PACKAGE_PATH,
                    key_user="yabs-commiter",
                    use_new_format=True,
                    version=self.Parameters.version,
                    package_type="tarball",
                    checkout_arcadia_from_url=self.Parameters.arcadia_url,
                    resource_type="YABS_VH_BACKEND_WEB_SERVICES",
                    checkout=True,
                ).enqueue()
            )

            debuilder_task = sdk2.Task["YABS_DEBUILDER"]
            tasks_to_wait.append(
                debuilder_task(
                    self,
                    description="Build VH Backend {version}".format(version=version),
                    ArcadiaPath=os.path.join(self.Parameters.arcadia_url, VH_BACKEND_PATH),
                    RunBambooTests=False,
                    PackageVersion=version,
                ).enqueue()
            )

            waited_statuses = set(common.utils.chain(ctt.Status.Group.FINISH, ctt.Status.Group.BREAK))
            raise sdk2.WaitTask(
                tasks_to_wait,
                waited_statuses
            )

        subtasks = self.find(status=ctt.Status.Group.SUCCEED)
        if subtasks.count != BUILD_TASKS_COUNT:
            raise common.errors.TaskFailure("Didn't manage to build packages. Maybe another time")

        dumb_resource = sdk2.ResourceData(
            BuildVhBackendPgaasDumbResource(
                self,
                description="Crutch resource to enforce release in testing",
                path="dumb_file"
            ),
        )
        dumb_resource.path.write_bytes("")
