from sandbox import sdk2
import sandbox.projects.resource_types.releasers as resource_releasers

from sandbox.projects.common.nanny import nanny

import json


class ChannelSpriteConfig(sdk2.Resource):
    """
        Crutch for vh backend build task
    """
    releasers = resource_releasers.vh_backend_releasers
    releasable = True
    ttl = "inf"


class SpriteConfigUploader(nanny.ReleaseToNannyTask2, sdk2.Task):
    """
        Build VH Backend
    """

    class Context(sdk2.Task.Context):
        hash = ""

    class Parameters(sdk2.Parameters):
        sprite_config = sdk2.parameters.String(
            "Sprite config",
            required=True,
        )

        hash = sdk2.parameters.String(
            "hash"
        )

    def validate_config(self, config):
        for item in config:
            assert "url-white" in item
            assert "url-black" in item
            assert "position" in item

        return True

    def on_execute(self):
        sprite_config = json.loads(self.Parameters.sprite_config)
        self.Context.hash = self.Parameters.hash

        if self.validate_config(sprite_config):
            resource = sdk2.ResourceData(
                ChannelSpriteConfig(
                    self,
                    description="Sprite config with channel logo",
                    path="sprite_config.json"
                ),
            )
            resource.path.write_bytes(json.dumps(sprite_config))
