# coding: utf-8
import logging
import sys

from sandbox import sdk2

resolutions = (("169_1080p", ("1920", "1080")),
               ("169_720p", ("1280", "720")),
               ("169_576p", ("1024", "576")),
               ("169_480p", ("852", "480")),
               ("169_360p", ("640", "360")),
               ("169_270p", ("480", "270")),
               ("1511_576p", ("784", "576")),
               ("1511_240p", ("326", "240")),
               ("43_576p", ("768", "576")),
               ("43_540p", ("720", "540")),
               ("43_270p", ("360", "270")),
               ("43_240p", ("320", "240")),
               ("54_576p", ("720", "576")),
               ("54_240p", ("300", "240")))


class FaasConvertVideoVodTest(sdk2.Task):
    """ This task runs ffmpeg to convert AD video to multiple resolutions """

    class Parameters(sdk2.Task.Parameters):
        # custom parameters
        url = sdk2.parameters.Url("Source video url", required=True)
        s3_bucket = sdk2.parameters.String("S3 bucket name", required=True)
        s3_key_prefix = sdk2.parameters.String("S3 keys prefix", required=True)
        s3_meta_nmb = sdk2.parameters.String("S3 meta nmb")
        s3_dir = sdk2.parameters.String("S3 dir inside bucket")
        s3_testing = sdk2.parameters.Bool("Use testing S3 installation")

    def upload(self, temp_dir, files):
        import sandboxsdk.svn
        # Add arcadia sources dir to library lookup list.
        sys.path.append(sandboxsdk.svn.Arcadia.get_arcadia_src_dir("arcadia:/arc/trunk/arcadia/contrib/python/boto"))
        import boto
        from boto.s3.connection import OrdinaryCallingFormat

        s3_secret_key = sdk2.Vault.data("s3_secret_key")
        s3_secret_key_id = sdk2.Vault.data("s3_secret_key_id")
        host = "s3.mdst.yandex.net" if self.Parameters.s3_testing else "s3.mds.yandex.net"
        s3conn = boto.connect_s3(aws_access_key_id=s3_secret_key_id,
                                 aws_secret_access_key=s3_secret_key,
                                 host=host, port=443, is_secure=True,
                                 calling_format=OrdinaryCallingFormat())
        bucket = s3conn.get_bucket(self.Parameters.s3_bucket)
        logging.info("Connected")

        if self.Parameters.s3_dir and self.Parameters.s3_dir[-1] != "/":
            self.Parameters.s3_dir += "/"

        for name in files:
            with open("{}/{}".format(temp_dir, name), "rb") as data:
                key = bucket.new_key(self.Parameters.s3_dir + name)
                if self.Parameters.s3_meta_nmb:
                    key.set_metadata('nmb', self.Parameters.s3_meta_nmb)
                key.set_contents_from_file(data)
                logging.info("Uploaded file {}".format(self.Parameters.s3_dir + name))

        logging.info("Upload finished")

    def build_ffmpeg_command(self, temp_dir, prefix):
        num = len(resolutions)
        filters = []
        outfiles = []
        files = []

        filters.append("[0:v]framerate=25[int]; [int]split={}{}".format(num, "".join(
            map(lambda i: "[int{}]".format(i), xrange(num)))))

        for i in xrange(num):
            filters.append(
                "[int{i}]scale=min({width}\, {height}*dar):-1,pad={width}:{height}:(ow-iw)/2:(oh-ih)/2:black[out{i}]"
                .format(i=i, width=resolutions[i][1][0], height=resolutions[i][1][1]))
            outfiles.append(
                "-map '[out{i}]' -c:v libx264 -profile baseline -g 10 -map 0:a -c:a aac -ar 48000 {tmp}/{prefix}_{suffix}.mp4"
                .format(i=i, tmp=temp_dir, prefix=prefix, suffix=resolutions[i][0]))
            files.append("{prefix}_{suffix}.mp4".format(prefix=prefix, suffix=resolutions[i][0]))

        return (";".join(filters), " ".join(outfiles), files)

    def on_execute(self):
        logging.info("Downloading resource with ffmpeg binary")
        pass

        #
        # ffmpeg_res = list(sdk2.Resource.find(
        #     resource_types.FFMPEG_BIN).limit(1))[0]
        # ffmpeg = sdk2.ResourceData(ffmpeg_res)
        #
        # logging.info("Resource downloaded")
        # logging.info(str(ffmpeg_res))
        #
        # with sdk2.helpers.ProcessLog(self, logger=logging.getLogger("cmd")) as pl:
        #     sp.Popen("ls -l " + str(ffmpeg.path), shell=True, stdout=pl.stdout, stderr=sp.STDOUT).wait()
        # ffmpeg_bin = str(ffmpeg.path / "ffmpeg")
        #
        # logging.info("Downloading video")
        # src_video = tempfile.NamedTemporaryFile(suffix=".mp4").name
        # with sdk2.helpers.ProcessLog(self, logger=logging.getLogger("cmd")) as pl:
        #     pr = sp.Popen("wget -O '{}' '{}'".format(src_video, self.Parameters.url), shell=True, stdout=pl.stdout, stderr=sp.STDOUT)
        #     pr.wait()
        #     if pr.returncode != 0:
        #         raise common.errors.TaskFailure("Something went wrong")
        # logging.info("Downloaded video")
        #
        # temp_dir = tempfile.mkdtemp()
        # try:
        #     (filter_complex, outfiles, files) = self.build_ffmpeg_command(temp_dir, self.Parameters.s3_key_prefix)
        #     cmdline = "{} -y -i '{}' -filter_complex '{}' {}".format(ffmpeg_bin, src_video, filter_complex, outfiles)
        #     logging.info("ffmpeg command line: {}".format(cmdline))
        #
        #     logging.info("Running ffmpeg")
        #     with sdk2.helpers.ProcessLog(self, logger=logging.getLogger("cmd")) as pl:
        #         pr = sp.Popen(cmdline, shell=True, stdout=pl.stdout, stderr=sp.STDOUT)
        #         pr.wait()
        #         if pr.returncode != 0:
        #             raise common.errors.TaskFailure("Something went wrong")
        #     logging.info("Finished converting")
        #
        #     logging.info("Upload to S3")
        #     self.upload(temp_dir, files)
        #     logging.info("Uploaded to S3")
        #
        # except:
        #     raise
        # finally:
        #     shutil.rmtree(temp_dir)
