# -*- coding: utf-8 -*-

from sandbox import sdk2
from sandbox.common.types import resource as ctr
import sandbox.projects.resource_types.releasers as resource_releasers


vh_releasers = [
    'tolich', 'i-sokolov', 'vandermond', 'fawnd2', 'woodie', 'proller', 'maxony', "robot-vh-master", "diman", "indigo", "dronimal"
]


SQL_READER_CONFIG = {
    "hosts": [
        "vh01e.yabs.yandex.ru",
        "vh01i.yabs.yandex.ru",
    ],
    "user": "mkdb",
    "sandbox_user": "VH-TESTER",
}

RESTORE_DESCRIPTION = {
    "yabs.vh.ContentTemplate": "bsdb",
    "yabs.vh.ContentResource": "bsdb",
    "yabs.vh.ContentVersion": "bsdb",
    "yabs.vh.OutputStream": "bsdb",
    "yabs.vh.ContentVersionGroup": "bsdb",
    "yabs.vh.ContentGroup": "bsdb",
    "yabs.vh.ContentType": "bsdb",
    "yabs.vh.ProductService": "bsdb",
    "yabs.yabsdb.RegionTree": "bsdb",
}

MYSQL_DB_RESOURCE_PATH = "mysql_tables.tar.gz"


class AppHostConfigBundleVh(sdk2.Resource):
    """
        Config bundle for app host vh
    """
    releasers = vh_releasers
    releasable = True
    share = True


class VHDatabaseSnapshot(sdk2.Resource):
    """
        Snapshot of vh database for frontend daemon.
    """
    share = True


class VHPerfResourceCoefficient(sdk2.Resource):
    """
        Coefficient of vh resources for frontend perfomance tests.
    """
    share = True


class DolbilkaDumpResult(sdk2.Resource):
    """
        Result dump
    """
    share = True


class VhDolbilkaShootingStats(sdk2.Resource):
    """
        Dolbilka shooting statistics
    """
    share = True


class VhDolbilkaRawRequests(sdk2.Resource):
    """
        File with requests for VhDolbilkaPlanCreator (url + headers)
    """
    share = True


class Back2BackDiff(sdk2.Resource):
    """
        Diffs from shoot two stands
    """
    share = True


class VhFrontendSqlTables(sdk2.Resource):
    """
        MySQL dump of vh frontend database
    """
    share = False


class VH_DOLBILKA_PLAN(sdk2.Resource):
    """
        VH plan for dolbilo
    """


class VH_DOLBILKA_REQUESTS(sdk2.Resource):
    """
        Used requests for dolbilo
    """


class YABS_VH_FRONTEND_RELEASE(sdk2.resource.AbstractResource):
    releasable = True
    any_arch = False
    auto_backup = True
    releasers = resource_releasers.vh_frontend_releasers + ['robot-testenv']
    restart_policy = ctr.RestartPolicy.DELETE


class VH_UGC_PUMPKIN_RELEASE(sdk2.resource.AbstractResource):
    releasable = True
    any_arch = False
    auto_backup = True
    releasers = resource_releasers.vh_frontend_releasers + ['robot-testenv']
    restart_policy = ctr.RestartPolicy.DELETE


class YABS_VH_FRONTEND_TRUNK(sdk2.resource.AbstractResource):
    releasable = True
    any_arch = False
    auto_backup = True
    releasers = resource_releasers.vh_frontend_releasers + ['robot-testenv']
    restart_policy = ctr.RestartPolicy.DELETE


class FRONTEND_VIDEO_HOSTING_PACKAGE(sdk2.Resource):
    """
        Frontend VH Package
    """


class VH_FAST_SETTINGS(sdk2.Resource):
    releasable = True
    """
        VH frontend fast settings
    """


class VhFlatCarousels(sdk2.Resource):
    releasable = True
    """
        VH frontend fast settings
    """


class VhFrontendIndexBinary(sdk2.Resource):
    """
        Indexvh binary
    """


class VhSamogonCtl(sdk2.Resource):
    releasable = True
    releasers = ['architect', 'w495', 'faustkun', 'matveieff', 'smalashkevich']
    """
        Samogonctl vh binary
    """


class VhLb2YdbBinary(sdk2.Resource):
    """
        Vh binary to transfer data from logbroker to YDB
    """


class VhAppHostBackendsGenerator(sdk2.Resource):
    """
        Vh tool for generating apphost config
    """
    releasers = vh_releasers
    releasable = True
    share = True


class VhAppHostBackendsJson(sdk2.Resource):
    """
        Vh tool for generating apphost config
    """
    releasers = vh_releasers
    releasable = True
    share = True


class VH_MYSQL_TO_YT_APPLIER_CONFIG(sdk2.Resource):
    releasable = True
    any_arch = False
    auto_backup = True
    releasers = ['architect', 'w495', 'faustkun', 'matveieff']


class VhPlayerMediaboxVersion(sdk2.Resource):
    """Player's mediabox version"""
    releasable = True
    releasers = vh_releasers + ['MEDIABOX_RELEASERS']
    release_subscribers = ['i-sokolov']


class VhPlayerVersion(sdk2.Resource):
    """Player version"""
    releasable = True
    releasers = vh_releasers + ['MEDIABOX_RELEASERS']


class VhPlayerSkinVersion(sdk2.Resource):
    """Player skin version"""
    releasable = True
    releasers = vh_releasers + ['MEDIABOX_RELEASERS']


class VhLangDetectData(sdk2.Resource):
    """lang_detect_data.txt"""
    releasable = True
    releasers = vh_releasers


class VhToUgcBloggersMapping(sdk2.Resource):
    releasable = True
    releasers = resource_releasers.vh_frontend_releasers + resource_releasers.vh_backend_releasers
    release_subscribers = ['fawnd2']


class VH_PLAYLIST_SERVICE_BIN(sdk2.Resource):
    releasable = True
    releasers = resource_releasers.vh_frontend_releasers + ['robot-testenv']


class PLAYLIST_BASE_GENERATION_BINARY(sdk2.Resource):
    releasable = True
    releasers = resource_releasers.vh_frontend_releasers + ['robot-testenv']


class VhIndexesDumperBinary(sdk2.Resource):
    releasable = True
    releasers = resource_releasers.vh_frontend_releasers + ['robot-testenv']
    release_subscribers = ['fawnd2']


class VhFlatCinfBase(sdk2.Resource):
    modification_time = sdk2.parameters.Integer("modification_time")
    releasable = True
    releasers = resource_releasers.vh_frontend_releasers + ['robot-testenv']
    release_subscribers = ['fawnd2']


class VhFlatConst(sdk2.Resource):
    """
       flat const file
    """


class PlaylistExperimentStreamMapping(sdk2.Resource):
    """
        Mapping to change stream in experiment
    """
    releasers = vh_releasers + ['lakhtanov']
    releasable = True


class PlaylistServiceVHPumpkin(sdk2.Resource):
    """
        Playlist service vh pumpkin
    """
    releasers = vh_releasers
    releasable = True
    sync_upload_to_mds = None


class PlaylistServiceUgcPumpkin(sdk2.Resource):
    """
        Playlist service ugc pumpkin
    """
    releasers = vh_releasers
    releasable = True
    sync_upload_to_mds = None


class PlaylistServiceRedisPumpkin(sdk2.Resource):
    """
        Playlist service redis pumpkin
    """
    releasers = vh_releasers
    releasable = True
    sync_upload_to_mds = None


class VH_REDIS_SERVICE(sdk2.resource.AbstractResource):
    """
        Redis service
    """
    releasable = True
    releasers = vh_releasers


class VH_REDIS_SENDER(sdk2.resource.AbstractResource):
    """
        Redis sender fro playlist
    """
    releasable = True
    releasers = vh_releasers


class VH_BASE_GENERATION(sdk2.resource.AbstractResource):
    """
        Index dumper (basegen for fallback)
    """
    releasable = True
    releasers = vh_releasers
