class UpstreamBuilder(object):

    def __init__(self, new_version=None, backends_list=None):
        self.__new_version = new_version
        self.__backends_list = backends_list

    __default_config = """
auth:
  staff:
    owners:
      logins:
      - architect
      groups: []
labels:
  order: '00001000'
---
regexp_section:
  matcher:
    match_fsm:
      uri: '/{VERSION_TO_CHANGE}/(.*)'
  modules:
    - report: {{uuid: {VERSION_TO_CHANGE}, ranges: default}}
    - rewrite:
        actions:
          - regexp: '/{VERSION_TO_CHANGE}/(.*)'
            rewrite: '/public/%1'
    - cookie_hasher:
        cookie: yandexuid
    - balancer2:
        attempts: 3
        rr: {{}}
        by_hash_policy:
          unique_policy: {{}}
        backends:
        - weight: 1
          name: !f prefix_with_dc('prod')
          modules:
            - report: {{uuid: requests_to_prod, ranges: default}}
            - balancer2:
                attempts: 4
                rr: {{}}
                by_hash_policy:
                  timeout_policy:
                    timeout: 1s
                    unique_policy: {{}}
                generated_proxy_backends:
                  proxy_options:
                    backend_timeout: 3s
                    connect_timeout: 50ms
                    keepalive_count: 1
                  include_backends:
                    type: BY_ID
                    ids: [{BACKENDS_LIST}]
"""

    def get_backend_name(self, number):
        default_name = 'bootstrap_vh{}'
        return default_name.format("") if number == 0 else default_name.format(number)  # all backends have format bootstrap_vh{number} except zero (bootstrap_vh)

    def __generate_backends_list(self):
        backends_list = [self.get_backend_name(int(number)) for number in (self.__backends_list)]
        return ', '.join(map(str, backends_list))

    def set_new_version(self, new_version):
        self.__new_version = new_version

    def set_backends(self, backends):
        self.__backends_list = backends

    def generate_config(self):
        assert self.__new_version is not None and self.__backends_list is not None
        return self.__default_config.format(VERSION_TO_CHANGE=self.__new_version, BACKENDS_LIST=self.__generate_backends_list())
