from sandbox.sdk2.helpers import subprocess as sp
from sandbox.projects.common.utils import sync_last_stable_resource
from sandbox.projects.vh.frontend import (
    # YABS_VH_FRONTEND_RELEASE,
    VhSamogonCtl,
)
from sandbox import sdk2
import logging


class VhDeployComponent(sdk2.Task):
    """ Task to generate lua templates from trunk """

    class Parameters(sdk2.Task.Parameters):

        ya_package_resource = sdk2.parameters.Resource(
            "Prebuilt vh frontend package",
            required=True,
            # type=YABS_VH_FRONTEND_RELEASE,  # FIXME: invalid argument (SANDBOX-6404)
        )

        component_number = sdk2.parameters.Integer(
            "deploy contour",
            required=True,
        )

    @property
    def get_deploy_component_number(self):
        if self.Parameters.component_number == 0:
            return ""
        else:
            return self.Parameters.component_number

    @property
    def get_oauth_token(self):
        return sdk2.Vault.data(self.owner, 'SAMOGON_API_TOKEN')

    def deploy_countour(self):
        samogon_ctl = sync_last_stable_resource(VhSamogonCtl)
        with sdk2.helpers.ProcessLog(self, logger=logging.getLogger("samogon_ctl")) as pl:
            sp.Popen(
                [
                    samogon_ctl,
                    "--service", "vh{}".format(self.get_deploy_component_number),
                    "--token", self.get_oauth_token,
                    "setcurrentpack", "sbr:{}".format(self.Parameters.ya_package_resource.id)
                ],
                stdout=pl.stdout,
                stderr=pl.stderr,
            ).wait()

    def on_execute(self):
        self.deploy_countour()
