from sandbox.sandboxsdk.svn import Arcadia
from sandbox.sdk2.helpers import subprocess as sp
from sandbox.projects.release_machine.core import const as rm_const
from sandbox import sdk2
import os
import logging


class VhGenerateMessageTemplates(sdk2.Task):
    """ Task to generate message templates from trunk """

    class Parameters(sdk2.Task.Parameters):
        arcadia_url = sdk2.parameters.ArcadiaUrl(
            "Arcadia url",
            required=True,
        )

    FRONTEND_VH_PATH = "arcadia/yabs/vh/frontend"
    MESSAGE_UPLOAD_SCRIPT_DIR = "arcadia/yabs/vh/frontend/templates"
    SANDBOX_OAUTH_VAULT_NAME = "OAUTH_TOKEN"

    def on_execute(self):
        Arcadia.checkout(self.Parameters.arcadia_url, 'arcadia', depth='files')
        Arcadia.update(self.FRONTEND_VH_PATH, parents=True, set_depth='infinity')
        os.environ["PATH"] += ':{}'.format(str(self.path('arcadia/')))
        os.environ["SANDBOX_OAUTH"] = sdk2.Vault.data(rm_const.COMMON_TOKEN_OWNER, self.SANDBOX_OAUTH_VAULT_NAME)
        os.chdir(self.MESSAGE_UPLOAD_SCRIPT_DIR)
        with sdk2.helpers.ProcessLog(self, logger=logging.getLogger("cmd")) as pl:
            pl.logger.setLevel(logging.DEBUG)
            sp.Popen(
                ["bash", "upload_to_sandbox_for_tests.sh", rm_const.COMMON_TOKEN_OWNER],
                stdout=pl.stdout,
                stderr=pl.stderr,
            ).wait()

        with open(str(self.log_path('common.log')), 'r') as logfile:
            for line in logfile:
                if 'Created resource id' in line:
                    self.Context.message_templates = line.split()[10]
                    break
