from sandbox import sdk2
import logging
import time

from sandbox.sandboxsdk.environments import PipEnvironment


class VhIndexSnapshotCreator(sdk2.Task):
    """ Task to create index table snapshot """

    class Requirements(sdk2.Requirements):
        environments = (PipEnvironment('yandex-yt'), )

    class Parameters(sdk2.Task.Parameters):
        prod_index_table_path = sdk2.parameters.String(
            "Index table to copy",
            default="//home/videoindex/full/vh/prevdata/Index",
        )

        snapshot_index_table_path = sdk2.parameters.String(
            "Path to snapshot index table",
            default="//home/videoindex/full/vh/snapshots/Index",
        )

    YT_PROXIES = [
        "arnold.yt.yandex.net",
        "hahn.yt.yandex.net",
    ]

    @property
    def yt_token(self):
        return sdk2.Vault.data(self.owner, "yt_token")

    def on_execute(self):
        import yt.wrapper as yt
        for yt_proxy in self.YT_PROXIES:
            yt_client = yt.YtClient(proxy=yt_proxy, token=self.yt_token)
            logging.info('Goint to create snapshot table "{0}"'.format(self.Parameters.snapshot_index_table_path))
            yt_client.copy(self.Parameters.prod_index_table_path, self.Parameters.snapshot_index_table_path, force=True, recursive=True)
            yt_client.set(self.Parameters.snapshot_index_table_path + '/@update_time', time.time())
