import logging
from sandbox import sdk2
from sandbox.projects.common.nanny import nanny

import requests
import json
import time


class VhPopularThematics(sdk2.Resource):
    """ json  wit popular thematis"""


class VhReadPopularThematics(nanny.ReleaseToNannyTask2, sdk2.Task):
    """ task read data for thematics_url and parse it to resource"""
    class Parameters(sdk2.Task.Parameters):
        thematics_url = sdk2.parameters.String("thematics url", required=True)

    def try_get_answer(self):
        for i in range(10):
            logging.info("attempt " + str(i))
            resp = requests.get(self.Parameters.thematics_url, timeout=5)
            logging.info("Got code: " + str(resp.status_code))

            if resp.status_code == 200:
                logging.info("OK")
                return resp

            time.sleep(10)

    def on_execute(self):
        logging.info("start task")
        logging.info("GET: " + self.Parameters.thematics_url)
        resp = self.try_get_answer()

        logging.info("got content: " + resp.text)
        content = resp.json()["content"]

        thematics = {}
        for supertag in content:
            thematics[supertag] = [them["title"] for them in content[supertag]]

        thematics_string = json.dumps(thematics)
        logging.info("DUMP: " + thematics_string)

        resource = sdk2.ResourceData(VhPopularThematics(
            self, "Output file", "thematics.json", released="stable"
        ))
        logging.info(dir(resource))
        logging.info(dir(resource.path))
        resource.path.write_bytes(thematics_string)
        logging.info("wrote resourse")
