import requests

from sandbox import sdk2
from sandbox import common

from sandbox.common.types import task as ctt

from sandbox.projects.common.nanny import nanny

from sandbox.projects.vh.frontend import VhLangDetectData


class VhUpdateLangDetectData(nanny.ReleaseToNannyTask2, sdk2.Task):
    """Updates lang_detect_data.txt file for frontend.vh.yandex.ru"""

    class Parameters(sdk2.Parameters):
        secret = sdk2.parameters.YavSecret("robot-vh-master-password", default="sec-01ffqs4rz8bwkhcsteh06pgafg")

    def on_execute(self):
        url = "https://svn.yandex.ru/lang-detect/trunk/data/lang_detect_data.txt"
        resource = VhLangDetectData(self, "Lang detect data file", "lang_detect_data.txt", released="stable")
        secret = self.Parameters.secret.data()
        username = "robot-vh-master"
        password = secret["password"]
        response = requests.get(url, auth=(username, password))
        if response.status_code == 200:
            resource.path.write_bytes(response.content)
        else:
            raise common.errors.TaskFailure("Status code is not 200")

    def on_success(self, prev_status):
        sdk2.Task.on_success(self, prev_status)
        nanny.ReleaseToNannyTask2.on_release(self, dict(
            releaser=self.author,
            release_status=ctt.ReleaseStatus.STABLE,
            email_notifications=dict(to=[], cc=[]),
            release_comments='Lang detect data file release',
        ))
