import re

from sandbox import common
from sandbox import sdk2

from sandbox.projects.common.nanny import nanny

from sandbox.projects.vh.frontend import VhPlayerMediaboxVersion, VhPlayerVersion, VhPlayerSkinVersion


class VhUpdatePlayerVersion(nanny.ReleaseToNannyTask2, sdk2.Task):
    """Updates player's mediabox version for frontend.vh.yandex.ru"""

    class Parameters(sdk2.Task.Parameters):
        mediabox_version = sdk2.parameters.String(
            "Player mediabox version",
            required=True
        )
        player_version = sdk2.parameters.String(
            "Player version"
        )
        player_skin_version = sdk2.parameters.String(
            "Player skin version"
        )

    def validation_check(self, input_string, expression):
        match = re.match(expression, input_string)
        return bool(match)

    def write_version_data_to_file(self, version, regexp, sandbox_resource):
        if version:
            if not self.validation_check(str(version), regexp):
                raise common.errors.TaskFailure("Invalid {} format, required {}".format(sandbox_resource.type, regexp))

            version_data = sdk2.ResourceData(sandbox_resource)
            version_data.path.write_bytes(version.encode("utf-8"))

    def on_execute(self):
        if self.Parameters.mediabox_version:
            self.write_version_data_to_file(self.Parameters.mediabox_version, "0x[01-9a-f]+", VhPlayerMediaboxVersion(
                self,
                "Player mediabox version",
                "player_mediabox_version.txt"
            ))
        if self.Parameters.player_version:
            self.write_version_data_to_file(self.Parameters.player_version, "1.0-\d+", VhPlayerVersion(
                self,
                "Player version",
                "player_version.txt"
            ))
        if self.Parameters.player_skin_version:
            self.write_version_data_to_file(self.Parameters.player_skin_version, "1.0-\d+", VhPlayerSkinVersion(
                self,
                "Player skin version",
                "player_skin_version.txt"
            ))
