# -*- coding: utf-8 -*-

# YT paths
# For readability all paths are fully specified (no expressions like YT_YABS_ROOT + "/...")
YT_YABS_ROOT = "//home/yabs"
YT_RELEASE_PATH = "//home/yabs/release"
YT_STAT_PATH = "//home/yabs/stat"
YT_PREPROD_STAT_PATH = "//home/yabs/stat/preprod"
YT_TEMP_PATH = "//home/yabs/stat/tmp"
YT_APP_CONTROL_PATH = "//home/yabs/stat/AppControl"
YT_LOCK_PATH = "//home/yabs/stat/Locks/YabsYtStat"

# Service tables path
PREPROD_STATE_TABLE = "//home/yabs/stat/PreprodState"
LOG_PROCESSING_STATUS_TABLE = "//home/yabs/stat/LogProcessingStatus"
PROCESSING_STAGE_TABLE = "//home/yabs/stat/ProcessingStage"
LOG_ROW_COUNT_TABLE = "//home/yabs/stat/LogRowCount"

COLLECTOR_RESOURCE_TYPE = "YABS_YTSTAT_COLLECTOR"
COLLECTOR_TASK_TYPE = "YABS_YT_STAT_COLLECTOR"


def _create_enum(tp, names):
    enum = type(tp, (), {n.upper(): n for n in names})
    enum.all = [n for n in names]
    return enum


ReleaseTypeEnum = _create_enum("ReleaseTypeEnum", [
    "prod", "preprod"
])

PreprodStateEnum = _create_enum("PreprodStateEnum", [
    "stopping_all",
    "cloning",
    "cloned",
    "run_all",
    "clone_failed",
    "stopping_preprod",
    "cleaning",
    "cleaned"
])
