#!/usr/bin/env python
# -*- coding: utf8 -*-

import logging

from yql.api.v1.client import YqlClient

import json

import consts

logging.basicConfig(
    level=logging.INFO,
    format='[%(levelname)s %(asctime)s]: %(message)s',
    datefmt='%m-%d-%Y %I:%M:%S'
)


if __name__ == "__main__":

    with open("params") as f:
        params = json.load(f)

    yt_cluster = params["yt_cluster"]
    yql_token = params["yql_token"]
    yql_request = params["yql_request"]
    date_time = params["date_time"]

    logging.info(yql_request)

    yql_query = yql_request.replace("<date_time>", date_time)

    logging.info("yql_query")
    logging.info(yql_query)

    logging.info("create yql client")
    client = YqlClient(
        db=yt_cluster,
        token=yql_token,
    )

    request = client.query(yql_query)
    request.run()

    if not request.get_results().is_success:
        error_description = '\n'.join([str(err) for err in request.get_results().errors])
        logging.error(error_description)
        if("Table" in error_description and "does not exist" in error_description):
            exit(consts.TABLE_NOT_EXISTS)
        raise RuntimeError(error_description)
