import os
import json

from sandbox.sandboxsdk.svn import Arcadia

from sandbox.projects.VideoSearch.video_resource_types import VIDEO_HUBTAG_RESTRICTIONS
from sandbox.projects.common.mediasearch import ban as mediaban
from sandbox.projects.common.nanny import auto_deploy


class VideoReleaseHubtagRestrictions(auto_deploy.AutoNannyDeployTask, mediaban.VideoBaseReleaseBanTask):
    """
        File for configure videohub doc2doc hubtag restrictions
    """

    type = "VIDEO_RELEASE_HUBTAG_RESTRICTIONS"

    input_parameters = mediaban.VideoBaseReleaseBanTask.input_parameters

    release_subject = "video/middle/videohub-hubtag_restrictions-{timestamp}"
    release_comment = "videohub hubtag restrictions"
    release_resources = (
        VIDEO_HUBTAG_RESTRICTIONS,
    )

    def get_stable_services(self):
        return [self._SERVICE_ID]

    def get_nanny_oauth_token(self):
        return self.get_vault_data('VIDEO-ROBOT', 'robot-video-crawl-nanny-oauth')

    def _build_ban(self):
        svn_url = 'arcadia:/arc/trunk/data/extsearch/video/quality/top/hub_doc2doc_restrictions.json'
        local_path = os.path.basename(svn_url)

        exported_path = self.abs_path(local_path)
        Arcadia.export(svn_url, exported_path)

        # test
        with open(exported_path, 'r') as in_file:
            json.load(in_file)

        has_changes = self._update_resource(VIDEO_HUBTAG_RESTRICTIONS, path=local_path)
        if not has_changes:
            return 0

        return os.stat(local_path).st_size


__Task__ = VideoReleaseHubtagRestrictions
