# -*- coding: utf-8 -*-
from sandbox.projects.common import metrics_launch_manager as metrics_launcher


class FinalResultStatuses():
    bad = 'Not ICE'
    good = 'ICE'
    awesome = 'COOL ICE!'


def generate_report(launcher, launch_id, mlm_launch_id):
    """
        Old-style mlm report (same as in ice-pip-mlm-report cm target)
    """
    info = launcher.get_launch_info(launch_id)
    warns = []
    crits = []
    for launch in info['launches']:
        for group in launch['diffQueryGroups']:
            for metric in group['metrics']:
                if metric['status'] == 'CRITICAL':
                    crits.append((
                        launch['name'],
                        group['filterGroupName'],
                        metric['metricName']
                    ))
                if metric['status'] == 'WARN':
                    warns.append((
                        launch['name'],
                        group['filterGroupName'],
                        metric['metricName']
                    ))
    final_result = None
    if len(crits) > 0:
        final_result = FinalResultStatuses.bad
    elif len(warns) > 0:
        final_result = FinalResultStatuses.good
    else:
        final_result = FinalResultStatuses.awesome
    report = ''
    report += '<b>ICE MLM check result: {} </b><br/>\n'.format(final_result)
    report += 'You can find more information here: {} <br/>\n'.format(
        metrics_launcher.get_mlm_link(mlm_launch_id, launch_id))
    if final_result != FinalResultStatuses.awesome:
        def _td(content):
            return '<td style=\"border: 1px solid black\">{}</td>'.format(content)
        report += '<p>Following metrics need manual investigation:</p>\n'
        for (signal, status, color) in [(crits, 'CRITICAL', 'red'), (warns, 'WARN', 'yellow')]:
            if not signal:
                continue
            report += '<p>Status <b>{0}</b></p>\n'.format(status)
            report += '<table style=\"border: 2px solid black\">'
            report += '<tr style=\"border: 1px solid black; background-color: lightsteelblue\">'
            for cell in ('Launch', 'Group', 'Metric'):
                report += _td(cell)
            report += '</tr>'
            for (launch, group, metric) in signal:
                report += '<tr style=\"border: 1px solid black; background-color: {0}\">'.format(color)
                for cell in (launch, group, metric):
                    report += _td(cell)
                report += '</tr>'
            report += '</table>'
        report += '<p style=\"margin-bottom: 7em\"></p>'
    return report
