import sandbox.sandboxsdk.svn as sdk_svn
import time
import json
import urllib2
import sys
from sandbox.projects.common import decorators

sys.path.append(sdk_svn.Arcadia.get_arcadia_src_dir("arcadia:/arc/trunk/arcadia/quality/relev_tools/conveyor_dashboard/commons"))
import nirvana_api as n_api

host_param = "upper-host"
ts_param = "timestamp"


class SharpEye():
    def __init__(self, workflow_id, nirvana_token):
        self._set_workflow(n_api.NirvanaAPI(workflow_id, nirvana_token))
        self._nirvana_token = nirvana_token

    def _set_workflow(self, workflow):
        self.workflow = workflow
        self.workflow_id = self.workflow.wfId

    @decorators.retries(10, delay=10, backoff=1)
    def _set_param(self, block, param, value):
        self.workflow.SetBlockParametersByGuid(block["blockGuid"], param, value)

    def _get_block_by_code(self, all_blocks, code):
        for block in all_blocks:
            if block["blockCode"] == code:
                return block
        return None

    def _get_blocks_with_param(self, all_blocks, param_name):
        result = []

        for block in all_blocks:
            for param in block["parameters"]:
                if param["parameter"] == param_name:
                    result.append(block)

        return result

    def _set_params(
            self,
            blocks,
            baseline_host,
            acceptance_host,
            baseline_fml_block_code_l1,
            baseline_fml_block_code_base,
            acceptance_fml_block_code_l1,
            acceptance_fml_block_code_base,
            baseline_scrape_block_codes,
            acceptance_scrape_block_codes):
        pool_blocks = self._get_blocks_with_param(blocks, host_param)
        ts = str(time.ctime())

        for block in self._get_blocks_with_param(blocks, ts_param):
            self._set_param(block, ts_param, ts)

        for code in baseline_scrape_block_codes:
            baseline_scrape_block = self._get_block_by_code(blocks, code)
            self._set_param(baseline_scrape_block, host_param, baseline_host)

        for code in acceptance_scrape_block_codes:
            acceptance_scrape_block = self._get_block_by_code(blocks, code)
            self._set_param(acceptance_scrape_block, host_param, acceptance_host)

        self.baseline_block_l1 = self._get_block_by_code(blocks, baseline_fml_block_code_l1)
        self.baseline_block_base = self._get_block_by_code(blocks, baseline_fml_block_code_base)

        self.acceptance_block_l1 = self._get_block_by_code(blocks, acceptance_fml_block_code_l1)
        self.acceptance_block_base = self._get_block_by_code(blocks, acceptance_fml_block_code_base)

    @decorators.retries(5, delay=5, backoff=1)
    def launch_sharp_eye(
            self,
            baseline_host,
            acceptance_host,
            baseline_fml_block_code_l1,
            baseline_fml_block_code_base,
            acceptance_fml_block_code_l1,
            acceptance_fml_block_code_base,
            baseline_scrape_block_codes=[],
            acceptance_scrape_block_codes=[]):
        self._set_workflow(self.workflow.CloneThisWorkflow())
        blocks = self.workflow.GetAllBlockParameters()["result"]
        self._set_params(
            blocks,
            baseline_host,
            acceptance_host,
            baseline_fml_block_code_l1,
            baseline_fml_block_code_base,
            acceptance_fml_block_code_l1,
            acceptance_fml_block_code_base,
            baseline_scrape_block_codes,
            acceptance_scrape_block_codes)
        self.workflow.StartWorkflow()

    def get_pool(self, block):
        data_storage = self.workflow.GetBlockResults(block["blockGuid"])["result"][0]["results"][0]["storagePath"]
        req = urllib2.Request(data_storage)
        req.add_header("Authorization", 'OAuth {0}'.format(self._nirvana_token))

        return json.loads(urllib2.urlopen(req).read())

    def get_pools(self):
        return {
            "baseline_l1": self.get_pool(self.baseline_block_l1)["id"],
            "baseline_base": self.get_pool(self.baseline_block_base)["id"],
            "acceptance_l1": self.get_pool(self.acceptance_block_l1)["id"],
            "acceptance_base": self.get_pool(self.acceptance_block_base)["id"],
        }

    def get_workflow_status(self):
        state = self.workflow.GetExecutionState()["result"]

        return {
            "status": state["status"],
            "result": state["result"]
        }

    def get_workflow_id(self):
        return self.workflow_id
