# -*- coding: utf-8 -*-

from sandbox import sdk2


class MlmTaskLauncher():
    task_type_name = 'VIDEO_ROBOT_PRIEMKA_LAUNCH_MLM'
    report_resource_type = 'VIDEO_ROBOT_PRIEMKA_MLM_REPORT'

    def __init__(self, parent_obj):
        self.parent_obj = parent_obj
        self.context = {}
        self.task_info = {}

    def set_vault_params(self, item, owner):
        self.context['vault_item'] = item
        self.context['vault_owner'] = owner

    def set_launch_params(self, env, owner):
        self.context['environment'] = env
        self.context['mlm_owner'] = owner

    def set_hosts(self, baseline_host, baseline_profile, acceptance_host, acceptance_profile):
        self.context['baseline_host'] = baseline_host
        self.context['baseline_profile'] = baseline_profile
        self.context['acceptance_host'] = acceptance_host
        self.context['acceptance_profile'] = acceptance_profile

    def launch_task(self):
        subtask = self._launch()
        self._save_task_info(subtask)

        return self.task_info, subtask.enqueue()

    def _launch(self):
        mlm_type = sdk2.Task[self.task_type_name]

        return mlm_type(
            self.parent_obj,
            description=self.parent_obj.Parameters.description,
            owner=self.parent_obj.owner,
            environment=self.context['environment'],
            mlm_launch_owner=self.context['mlm_owner'],
            baseline_host=self.context['baseline_host'],
            baseline_profile=self.context['baseline_profile'],
            acceptance_host=self.context['acceptance_host'],
            acceptance_profile=self.context['acceptance_profile'],
            vault_item=self.context['vault_item'],
            vault_owner=self.context['vault_owner']
        )

    def _save_task_info(self, task):
        self.task_info = {
            'id': task.id
        }

    def get_report(self, task_id):
        resource = list(
            sdk2.Resource.find(
                task_id=task_id,
                type=self.report_resource_type
            ).limit(1)
        )[0]
        resource_data = sdk2.ResourceData(resource)
        with resource_data.path.resolve().open() as f:
            return f.read()
