# -*- coding: utf-8 -*-
from sandbox import sdk2
from sandbox import common
import performance_configs


class PerformanceTaskLauncher():
    task_type_name = performance_configs.BetaSettings._ACCEPTANCE_PARAMS['task_type']

    def __init__(self, parent_obj):
        self.parent_obj = parent_obj
        self.beta_service = parent_obj.beta_service
        self.task_settings = None
        self.task_info = {}

    def set_sb_oauth(self, rest_api_server, owner, item):
        self.sb_rest_api_server = rest_api_server
        self.sb_oauth_item = item
        self.sb_oauth_owner = owner

    def set_nanny_service(self, priemka_service):
        self.priemka_nanny_service = priemka_service

    def set_nanny_oauth(self, owner, item):
        self.nanny_owner = owner,
        self.nanny_item = item

    def set_hosts(self, baseline_host, acceptance_host):
        self.baseline_host = baseline_host
        self.acceptance_host = acceptance_host

    def generate_performance_task_settings(self):
        settings = performance_configs.BetaSettings(
            self.sb_rest_api_server,
            self.sb_oauth_item,
            self.sb_oauth_owner,
            self.priemka_nanny_service,
            self.nanny_item,
            self.nanny_owner,
            self.baseline_host,
            self.acceptance_host,
            self.beta_service
        )

        return settings

    def launch_task(self):
        if not self.task_type_name:
            raise common.errors.TaskError("Task type is not defined")
        subtask = self._launch()
        self._save_task_info(subtask)

        return self.task_info, subtask.enqueue()

    def _launch(self):
        task_settings = self.task_settings or self.generate_performance_task_settings().videosearch_settings()
        task_settings.load_latest_stable_shard_names()
        context = task_settings.get_context()
        beta_index_name = task_settings.get_index_name()
        description = "{} {} priemka".format(beta_index_name, "index")
        task_type = sdk2.Task[self.task_type_name]

        return task_type(
            self.parent_obj,
            owner=self.parent_obj.owner,
            description=description,
            new_basesearch_database_shards=context['new_basesearch_database_shards'],
            old_basesearch_database_shards=context['old_basesearch_database_shards'],
            shards_count=context['shards_count'],
            force_load_basesearch_database=context['force_load_basesearch_database'],
            use_rbtorrent_transport=context['use_rbtorrent_transport'],
            kill_timeout=context['kill_timeout']
        )

    def _save_task_info(self, task):
        self.task_info = {
            'id': task.id
        }
