# -*- coding: utf-8 -*-

from sandbox import sdk2


class SharpEyeTaskLauncher():
    task_type_name = 'VIDEO_ROBOT_PRIEMKA_SHARP_EYE'

    def __init__(self, parent_obj):
        self.parent_obj = parent_obj
        self.context = {}
        self.task_info = {}

    def set_launch_params(self, env):
        self.context['environment'] = env

    def launch_task(self):
        subtask = self._launch()
        self._save_task_info(subtask)

        return self.task_info, subtask.enqueue()

    def _launch(self):
        sharp_eye_type = sdk2.Task[self.task_type_name]

        return sharp_eye_type(
            self.parent_obj,
            description=self.parent_obj.Parameters.description,
            owner=self.parent_obj.owner,
            environment=self.context['environment'],
        )

    def _save_task_info(self, task):
        self.task_info = {
            'id': task.id
        }

    def get_report(self, task_id):
        pass
