# coding: utf-8

import os

from sandbox.sandboxsdk.process import run_process
from sandbox.sandboxsdk import environments
from sandbox.sandboxsdk import parameters
from sandbox.sandboxsdk import task
import sandbox.sandboxsdk.svn as sdk_svn
from sandbox.projects.common.juggler import jclient
from sandbox.projects.video import video_resource_types
import sandbox.common.types.client as ctc


class VIDEO_QUALITY_JUGGLER_PLAYBOOK_CONTAINER(video_resource_types.VIDEO_RELEASABLE_RESOURCE):
    pass


class PlaybookNameParameter(parameters.SandboxStringParameter):
    name = 'playbook_name'
    description = 'Playbook name'
    default_value = 'main.yml'
    required = True


class Container(parameters.Container):
    description = 'Container template'
    resource_type = VIDEO_QUALITY_JUGGLER_PLAYBOOK_CONTAINER
    required = True


class RunJugglerVideoQualityPlaybook(task.SandboxTask):
    """
    Apply juggler search playbook.
    """

    type = 'RUN_JUGGLER_VIDEO_QUALITY_PLAYBOOK'

    client_tags = ctc.Tag.LINUX_PRECISE

    input_parameters = [
        PlaybookNameParameter,
        Container
    ]

    environment = (
        environments.PipEnvironment("jmespath"),
        environments.PipEnvironment("ansible-juggler2"),
    )

    _REPO_URL = "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia/extsearch/video/quality/juggler"

    def on_execute(self):
        checkout_path = self.path("root")
        sdk_svn.Svn.checkout(url=self._REPO_URL, path=checkout_path)

        environment = os.environ.copy()
        environment['JUGGLER_OAUTH_TOKEN'] = self.get_vault_data('VIDEO-ROBOT', 'JUGGLER_OAUTH_TOKEN')

        run_process(['ansible-playbook', self.ctx['playbook_name']], work_dir=checkout_path, environment=environment, log_prefix="playbook")

        jclient.send_events_to_juggler('video_quality.sandbox', self.type, 'OK', 'Playbook run successfully')


__Task__ = RunJugglerVideoQualityPlaybook
