# -*- coding: utf-8 -*-

from sandbox.projects import resource_types
from sandbox.projects.common import utils
from sandbox.projects.common.base_search_quality import threadPool
from sandbox.projects.common.base_search_quality import response_saver
from sandbox.projects.common.middlesearch import single_host
from sandbox.projects.common.middlesearch.response_patcher import response_patcher
from sandbox.projects.common.search import components
from sandbox.sandboxsdk.channel import channel

import logging


_RESPONSE_SAVER_PARAMS = response_saver.create_response_saver_params(
    queries_resource=resource_types.VIDEO_MIDDLESEARCH_PLAIN_TEXT_REQUESTS
)


class VideoRecommenderGetMiddlesearchResponses(single_host.MiddlesearchSingleHostTask):
    """
        Starts 1 middlesearch instance.
        Save responses to ``PLAIN_TEXT_QUERIES`` in resources:
        ``BASESEARCH_HR_RESPONSES`` (human-readable output)
        or ``SEARCH_PROTO_RESPONSES`` (protobuf binary output).
    """

    type = 'VIDEO_RECOMMENDER_GET_MIDDLESEARCH_RESPONSES'

    input_parameters = \
        components.DefaultMiddlesearchParams.params \
        + _RESPONSE_SAVER_PARAMS.params \
        + threadPool.PARAMS

    def on_enqueue(self):
        single_host.MiddlesearchSingleHostTask.on_enqueue(self)
        response_saver.create_resources(self)

    def _use_middlesearch_component(self, middlesearch):
        patched_queries_resource = response_saver.get_patched_queries_resource(self)

        def save_responses_to_resource(res, prepare_session_func=None, test_with_doubled_queries=False):
            response_saver.save_responses(
                self.ctx,
                search_component=middlesearch,
                responses_resource=res,
                patched_queries_resource=patched_queries_resource,
                response_patchers=[response_patcher],
                prepare_session_callback=prepare_session_func,
                need_dbgrlv=False,
                test_with_doubled_queries=test_with_doubled_queries,
                ignore_empty_response=True,
            )

        #  if need to test responses correctness with cache disabled:
        if self.ctx.get(_RESPONSE_SAVER_PARAMS.TestWithCacheDisabled.name):
            logging.info("Getting responses with disabled cache")
            save_responses_to_resource(
                channel.sandbox.get_resource(self.ctx['without_cache_responses_id']),
                prepare_session_func=middlesearch.disable_cache,
            )

        logging.info("Getting responses with empty enabled cache")
        save_responses_to_resource(
            channel.sandbox.get_resource(self.ctx['out_resource_id']),
            prepare_session_func=middlesearch.clear_cache,
            test_with_doubled_queries=utils.get_or_default(self.ctx, _RESPONSE_SAVER_PARAMS.TestWithDoubledQueries),
        )

__Task__ = VideoRecommenderGetMiddlesearchResponses
