# -*- coding: utf-8 -*-

from sandbox import sdk2
import sandbox.common.types.task as ctt

from sandbox.common.errors import TaskFailure

from sandbox.projects.RunNirvanaWorkflow import RunNirvanaWorkflow


class VideoRecommenderRunSessionsWorkflow(sdk2.Task):
    """Run sessions workflow"""

    class Parameters(sdk2.Task.Parameters):
        nirvana_token = sdk2.parameters.String("Vault record with Nirvana token", required=True)
        nirvana_workflow_id = sdk2.parameters.String(
            "Nirvana workflow id",
            description="New workflow will be copied from this one",
            required=True
        )
        sandbox_token = sdk2.parameters.String("Nirvana secret with Sandbox token")

    def on_execute(self):
        Group = ctt.Status.Group

        with self.memoize_stage.first_run:
            Arcadia = sdk2.svn.Arcadia
            sessions_timestamp = Arcadia.info(Arcadia.trunk_url("/extsearch/video/quality/recommender/tools/sessions"))["date"]

            workflow_subtask = RunNirvanaWorkflow(
                self,
                description="Runs sessions tool workflow for task {}".format(self.id),
                owner="VIDEODEV",
                priority=self.Parameters.priority,
                nirvana_workflow_name="Sessions Workflow",
                nirvana_workflow_id=self.Parameters.nirvana_workflow_id,
                nirvana_token=self.Parameters.nirvana_token,
                nirvana_global_options={
                    "data_timestamp": sessions_timestamp,
                    "sessions_timestamp": sessions_timestamp,
                    "sandbox_oauth_token": self.Parameters.sandbox_token
                }
            ).enqueue()

            raise sdk2.WaitTask(workflow_subtask, Group.FINISH | Group.BREAK)

        with self.memoize_stage.restart_from_wait:
            if not all(task.status in Group.SUCCEED for task in self.find()):
                raise TaskFailure("Workflow has failed")
