# -*- coding: utf-8 -*-
import sandbox.common.types.task as ctt

from sandbox import sdk2
from sandbox.common.share import skynet_get

from sandbox.projects.common.nanny import nanny


class VideoVitrinaBuildIndex(nanny.ReleaseToNannyTask2, sdk2.Task):

    class Parameters(sdk2.Task.Parameters):
        skynet_resid = sdk2.parameters.String('Index files will be downloaded from this resource', required=True)

    def on_execute(self):
        database_local_path = 'database'
        sdk2.Resource['VIDEO_VITRINA_BASESEARCH_INDEX'](
            self,
            'index_prod_1.0',
            database_local_path,
            'any'
        )
        skynet_get(self.Parameters.skynet_resid, database_local_path)

    def on_success(self, prev_status):
        sdk2.Task.on_success(self, prev_status)
        nanny.ReleaseToNannyTask2.on_release(self, dict(
            releaser=self.author,
            release_status=ctt.ReleaseStatus.STABLE,
            release_subject="",
            email_notifications=dict(to=[], cc=[]),
            release_comments="",
        ))
