# -*- coding: utf-8 -*-

from sandbox.projects import BuildDynamicModels
from sandbox.projects.common.dynamic_models.compare import generate_diff_footer
from sandbox import sdk2


class ModelsForProduction(BuildDynamicModels.ModelsForProduction):
    default_value = True


class ModelsUrlForProduction(BuildDynamicModels.ModelsUrlForProduction):
    default_value = 'arcadia:/robots/branches/video/vitrina/meta_models'


class ModelsForExperiment(BuildDynamicModels.ModelsForExperiment):
    default_value = False


class CheckProductionModelsList(BuildDynamicModels.CheckProductionModelsList):
    default_value = False


class StrictFormulaIdChecks(BuildDynamicModels.StrictFormulaIdChecks):
    default_value = False


class FailWithoutSlices(BuildDynamicModels.FailWithoutSlices):
    default_value = True


class VideoVitrinaMetaModelsArchive(sdk2.resource.AbstractResource):
    any_arch = True
    auto_backup = True
    executable = False
    releasable = True
    releasers = ['vvp', 'palevas', 'alex0512', 'paul7']


class VideoVitrinaBuildModels(BuildDynamicModels.BuildDynamicModels):
    '''
        Таск выкачивает модели из SVN по указанному URL
        и собирает их в архив с помощью tools/archiver.
    '''

    type = 'VIDEO_VITRINA_BUILD_MODELS'

    description = 'Build ranking models archive for video vitrina'
    archive_name = 'models.archive'
    resourse_type = 'VIDEO_VITRINA_META_MODELS_ARCHIVE'

    input_parameters = (
        ModelsForProduction,
        ModelsUrlForProduction,
        ModelsForExperiment,
        CheckProductionModelsList,
        StrictFormulaIdChecks,
        FailWithoutSlices,
    )

    def get_resource_type(self):
        return 'VIDEO_VITRINA_META_MODELS_ARCHIVE'

    def filter_models(self, files):
        return files

    @property
    def footer(self):
        return generate_diff_footer(self.ctx.get('diff'))


__Task__ = VideoVitrinaBuildModels
