from sandbox.projects.common.mediasearch.build import BaseMediaBuildTask
import sandbox.projects.common.build.parameters as bp
import sandbox.common.types.client as ctc

import sandbox.projects.video.quality.recommender.VideoVitrinaCuba.resource_types as rt


class VideoVitrinaBuildBinary(BaseMediaBuildTask):
    type = "VIDEO_VITRINA_BUILD_BINARY"
    execution_space = 100 * 1024  # 100G

    client_tags = ctc.Tag.GENERIC & ctc.Tag.Group.LINUX

    def initCtx(self):
        self.ctx[bp.StripBinaries.name] = True

    def get_binaries(self):
        return (
            rt.CubaGenConfigPyBin,
            rt.CubaGenIndexAttrPyBin,
            rt.CubaGetPathNsPyBin,
            rt.CubaTableCheckerPyBin,
            rt.DeletePrevPyBin,
            rt.GetExtDataPyBin,
            rt.GrattrgenBin,
            rt.UploadNsPyBin,
            rt.VideoVitrinaBinCuba
        )
