from sandbox import sdk2
from sandbox.projects.common.BaseMediaBuildBundle_v3 import BaseMediaBuildBundle

import sandbox.projects.video.quality.recommender.VideoVitrinaCuba.resource_types as rt


class VideoVitrinaBuildBundle(BaseMediaBuildBundle):
    class Parameters(sdk2.Task.Parameters):
        BuildTask = sdk2.parameters.Task(
            "Task where video binaries has been built",
            task_type="VIDEO_VITRINA_BUILD_BINARY",
            required=True
        )

    class Requirements(BaseMediaBuildBundle.Requirements):
        disk_space = 20 * 1024  # 20Gb

    def get_resource_type(self):
        return rt.VideoVitrinaBundle

    def get_resource_descr(self):
        return "bin bundle"

    def get_resource_file_name(self):
        return "bin"

    def get_build_task(self):
        return self.Parameters.BuildTask.id

    def get_built_resources(self):
        return (
            [rt.VideoVitrinaBinCuba, "cuba"],
            [rt.CubaGenConfigPyBin, "gen_config"],
            [rt.CubaGenIndexAttrPyBin, "gen_indexattr"],
            [rt.CubaGetPathNsPyBin, "gen_path_ns"],
            [rt.CubaTableCheckerPyBin, "test_check_tables"],
            [rt.DeletePrevPyBin, "delete_prev"],
            [rt.GetExtDataPyBin, "get_ext_data"],
            [rt.UploadNsPyBin, "upload_ns"]
        )
