import os
from os.path import basename, join as pj

from sandbox import sdk2
from sandbox.sandboxsdk.svn import Arcadia

from sandbox.projects.video.quality.recommender.VideoVitrinaCuba.resource_types import VideoVitrinaDataDir


class VideoVitrinaBuildTestData(sdk2.Task):
    class Requirements(sdk2.Requirements):
        disk_space = 1024  # 1Gb

    class Parameters(sdk2.Task.Parameters):
        arcadia_url = sdk2.parameters.String("Url to Arcadia", default=Arcadia.trunk_url(), required=False)
        arcadia_patch = sdk2.parameters.String(
            "Apply patch (diff file rbtorrent, paste.y-t.ru link or plain text). Doc: https://nda.ya.ru/3QTTV4",
            default="", multiline=True
        )

    def get_resource_type(self):
        return VideoVitrinaDataDir

    def _full_a_url(self, apath):
        return pj(self.Parameters.arcadia_url, apath)

    @property
    def _arcadia_paths(self):
        return [
            "extsearch/video/quality/recommender/1492/cuba/test/data",
            "extsearch/video/quality/recommender/1492/cuba/config"
        ]

    def _out_dir(self, local_dir=""):
        return pj("full", local_dir)

    def _export_dir(self, local_dir=""):
        return pj("export", local_dir)

    def _export_data(self):
        os.mkdir(self._export_dir())
        for path in self._arcadia_paths:
            sandbox_dir = self._export_dir(path)
            Arcadia.export(self._full_a_url(path), sandbox_dir)
        self._apply_patch()
        self._collect_export()

    def _apply_patch(self):
        if self.Parameters.arcadia_patch.strip():
            Arcadia.apply_patch(self._export_dir(), self.Parameters.arcadia_patch, self.log_path())

    def _collect_export(self):
        os.mkdir(self._out_dir())
        for path in self._arcadia_paths:
            os.rename(self._export_dir(path), self._out_dir(basename(path)))

    def on_execute(self):
        self._export_data()
        result = sdk2.ResourceData(VideoVitrinaDataDir(self, "Cuba test data", self._out_dir()))
        result.ready()
