# -*- coding: utf-8 -*-
from sandbox import sdk2
import sandbox.common.types.client as ctc
import sandbox.common.types.task as ctt
import sandbox.common.errors


class BuildMegamindCi2(sdk2.Task):

    class Requirements(sdk2.Task.Requirements):
        client_tags = ctc.Tag.Group.LINUX
        cores = 1

    class Parameters(sdk2.Task.Parameters):
        pass

    class Context(sdk2.Task.Context):
        build_vins_package_id = None

    def on_execute(self):
        if not self.Context.build_vins_package_id:
            subtask = sdk2.Task['BUILD_VINS_PACKAGE'](self, description='Created from BUILD_MEGAMIND_CI', raw_package=True).enqueue()
            self.Context.build_vins_package_id = subtask.id
            raise sdk2.WaitTask([subtask], ctt.Status.Group.FINISH + ctt.Status.Group.BREAK, True)

        subtask = self.find(id=self.Context.build_vins_package_id).first()
        if subtask.status in ctt.Status.Group.SCHEDULER_FAILURE:
            raise sandbox.common.errors.TaskError(
                'Subtask {} ({}) was finished with the status of {}'.format(subtask.type, subtask.id, subtask.status))

        sdk2.Task.server.release(
            task_id=self.Context.build_vins_package_id,
            type=ctt.ReleaseStatus.UNSTABLE,
            subject=self.Parameters.description
        )
