# coding: utf-8

from sandbox import sdk2
from sandbox.common.errors import TaskError
from sandbox.common.types import client as ctc
from sandbox.common.types import task as ctt

DESCRIPTION = 'Created from BUILD_MEGAMIND_STANDALONE_CI'


class BuildMegamindStandaloneCi(sdk2.Task):
    class Requirements(sdk2.Task.Requirements):
        client_tags = ctc.Tag.Group.LINUX
        cores = 1

    class Parameters(sdk2.Task.Parameters):
        pass

    class Context(sdk2.Task.Context):
        build_megamind_package_id = None

    def on_execute(self):
        if not self.Context.build_megamind_package_id:
            subtask = sdk2.Task['BUILD_MEGAMIND_PACKAGE'](self, description=DESCRIPTION, raw_package=False).enqueue()
            self.Context.build_megamind_package_id = subtask.id
            raise sdk2.WaitTask([subtask], ctt.Status.Group.FINISH + ctt.Status.Group.BREAK, wait_all=True)

        subtask = self.find(id=self.Context.build_megamind_package_id).first()
        if subtask.status in ctt.Status.Group.SCHEDULER_FAILURE:
            msg = 'Subtask {} ({}) was finished with the status of {}'.format(subtask.type, subtask.id, subtask.status)
            raise TaskError(msg)

        sdk2.Task.server.release(
            task_id=self.Context.build_megamind_package_id,
            type=ctt.ReleaseStatus.UNSTABLE,
            subject=self.Parameters.description,
        )
