# coding: utf-8

from sandbox.projects.common.build import parameters as build_parameters
from sandbox.projects.common.nanny import nanny
from sandbox.projects.common.build.KosherYaPackage import KosherYaPackage
import sandbox.projects.common.constants as consts
from sandbox.projects.common.build.ya_package_config import consts as ya_package_consts


class BuildVinsPackage(KosherYaPackage, nanny.ReleaseToNannyTask2):

    class Requirements(KosherYaPackage.Requirements):
        pass

    class Parameters(KosherYaPackage.Parameters):
        resource_type = build_parameters.ResourceType(default_value='VINS_PACKAGE')
        packages = build_parameters.Packages(default_value='alice/vins/packages/vins_package.json')
        build_type = build_parameters.BuildType(default_value=consts.RELEASE_BUILD_TYPE)
        publish_package = build_parameters.PublishPackage(default_value=False)
        raw_package = build_parameters.RawPackage(default_value=True)
        package_type = build_parameters.PackageType(default_value=ya_package_consts.PackageType.TARBALL.value)
        do_not_remove_resources = build_parameters.DoNotRemoveResources2(default_value=True)
        compress_package_archive = build_parameters.CompressPackageArchive(default=False)

    def on_enqueue(self):
        super(BuildVinsPackage, self).on_enqueue()

    def on_release(self, additional_parameters):
        nanny.ReleaseToNannyTask2.on_release(self, additional_parameters)
        super(BuildVinsPackage, self).on_release(additional_parameters)
