# -*- coding: utf-8 -*-
import logging
import datetime

from dateutil import tz
from sandbox import sdk2

from sandbox.projects.release_machine import events as rm_events
from sandbox.projects.release_machine.helpers import events_helper


class NotifyVinsPackageReady(sdk2.Task):
    """Task to send notifications about prepared VINS packages"""

    class Parameters(sdk2.Task.Parameters):
        component_name = sdk2.parameters.String(
            'component_name',
            required=True
        )
        is_branch_build = sdk2.parameters.Bool(
            'is_branch_build',
            default=False,
            required=True
        )
        job_name = sdk2.parameters.String(
            'job_name',
            required=True
        )
        scope_number = sdk2.parameters.String(
            'scope_number',
            required=True
        )

    def _create_rm_event(self):
        event = rm_events.BuildTestEvent(
            component_name=self.Parameters.component_name,
            job_name=self.Parameters.job_name,
            referrer=self.id,
            scope_number=self.Parameters.scope_number,
            task_status="SUCCESS",

        )
        current_date = datetime.datetime.now().replace(tzinfo=tz.gettz())
        event.populate_info_with_task_data(
            task_id=self.id,
            created_at=current_date,
            updated_at=current_date,
        )
        return event

    def _send_rm_task_event(self):
        if not self.Parameters.is_branch_build:
            return
        try:
            events_helper.post_events([self._create_rm_event()])
        except Exception:
            self.set_info("Unable to send event")
            logging.exception("Event hasn't been sent due to unexpected error")

    def on_execute(self):
        self._send_rm_task_event()
