# -*- coding: utf-8 -*-

from sandbox import sdk2

vins_releasers = ['movb', 'zagevalo', 'zubchick', 'mkamalova', 'ran1s', 'a-square', 'ikorobtsev', 'g-kostin', 'galecore',
                  'petrk', 'vi002', 'akhruslan', 'a-sidorin', 'mihajlova', 'nkodosov', 'yakovdom', 'alkapov',
                  'zhigan', 'sparkle', 'ershov-ov', 'robot-srch-releaser', 'robot-testenv', 'robot-voiceint',
                  'aleexfi', 'yagafarov', 'alexanderplat', 'd-dima', 'klim-roma']


class VINS_SUGGEST_DATA(sdk2.Resource):
    """
    Package for query wizrds features
    """
    releasable = True
    any_arch = True
    executable = False
    auto_backup = True
    releasers = vins_releasers


class VINS_NORMALIZER(sdk2.Resource):
    """
    Archive with normalizer fsts
    """
    releasable = True
    any_arch = True
    executable = False
    auto_backup = True
    releasers = vins_releasers


class VINS_FST_DATA(sdk2.Resource):
    """
    Archive with tagger fsts
    """
    releasable = True
    any_arch = True
    executable = False
    auto_backup = True
    realesers = vins_releasers


class VinsTankLoadConfig(sdk2.Resource):
    """
    YandexTank config for performance test
    """
    any_arch = True
    executable = False
    auto_backup = True
    calc_md5 = True
    share = True


class VinsTankMonitoringConfig(sdk2.Resource):
    """
    Monitoring config for YandexTank
    """
    any_arch = True
    executable = False
    auto_backup = True
    calc_md5 = True
    share = True


class VinsTankAmmo(sdk2.Resource):
    """
    YandexTank ammo for VINS performance test
    """
    any_arch = True
    executable = False
    auto_backup = True
    calc_md5 = True
    share = True


class VinsPackage(sdk2.Resource):
    """
    VINS tarball package
    """
    any_arch = True
    executable = False
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = vins_releasers


class MegamindPackage(sdk2.Resource):
    """
    MEGAMIND tarball package
    """
    any_arch = True
    executable = False
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = vins_releasers


class AmandaPackage(sdk2.Resource):
    """
    Amanda tarball package
    """
    any_arch = True
    executable = False
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = vins_releasers


class AmeliePackage(sdk2.Resource):
    """
    Amelie tarball package
    """
    any_arch = True
    executable = False
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = vins_releasers


class OauthRedirectorPackage(sdk2.Resource):
    """
    OAuth redirector tarball package
    """
    any_arch = True
    executable = False
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = vins_releasers


class AliceReviewBotPackage(sdk2.Resource):
    """
    ReviewBot tarball package
    """
    any_arch = True
    executable = False
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = vins_releasers


class AliceInterpreterPackage(sdk2.Resource):
    """
    Alice interpreter tarball package
    """
    any_arch = True
    executable = False
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = vins_releasers


class VinsTestResult(sdk2.Resource):
    """
    VINS test result
    """
    executable = False


class VinsToolResource(sdk2.Resource):
    """
    Abstract VINS tool resource
    """
    executable = True


class VinsToolCompareResource(VinsToolResource):
    """
    VINS Tool to compare test runs
    """
    pass


class VinsToolPaResource(VinsToolResource):
    """
    VINS pa_tools
    """
    arcadia_build_path = 'alice/vins/tools/pa/pa_tools'


class PortoLayerVinsRedis(sdk2.Resource):
    """
    PortoLayer with redis-server installed
    """
    any_arch = True
    executable = False
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = vins_releasers


class JokerPackage(sdk2.Resource):
    """
    Package with joker binary
    """
    any_arch = True
    executable = False
    auto_backup = True
    calc_md5 = True
    share = True


class AlicePerfTestPackage(sdk2.Resource):
    """
    Package with joker binary and script for collecting alice metrics
    """
    any_arch = True
    executable = False
    auto_backup = True
    calc_md5 = True
    share = True


class StubsInfo(sdk2.Resource):
    """
    Folder with stubs names and corresponding responses
    """
    any_arch = True
    executable = False
    auto_backup = True
    calc_md5 = True
    share = True


class GoodwinScenarioBin(sdk2.Resource):
    """
    Package for Goodwin scenario server
    """
    releasable = True
    any_arch = True
    executable = False
    auto_backup = False
    releasers = vins_releasers
    arcadia_build_path = 'alice/scenarios/frame_filler/scenarios/goodwin/server'


class MegamindHelperBinaries(sdk2.Resource):
    """
    Helper binaries for functionality outside of Sandbox functions
    """
    auto_backup = True


class MegamindRequests(sdk2.Resource):
    """
    Package with real-world requests to Megamind
    """
    auto_backup = True


class MegamindResponses(sdk2.Resource):
    """
    Package with responses to real-world requests to Megamind
    """
    pass


class MegamindDiff(sdk2.Resource):
    """
    Package with diffs of responses to real-world requests to Megamind
    """
    pass


class MegamindPerformanceDiff(sdk2.Resource):
    """
    Package with info about Megamind performance comparison
    """
    pass


class MegamindShooterBinary(sdk2.Resource):
    """
    Megamind shooter binary
    """
    auto_backup = True
    executable = True


class MegamindRequestsMinerBinary(sdk2.Resource):
    """
    Megamind requests miner binary
    """
    auto_backup = True
    executable = True


class MegamindRequestsLoaderBinary(sdk2.Resource):
    """
    Megamind requests loader binary
    """
    auto_backup = True
    executable = True


class BufImage(sdk2.Resource):
    """
    Protobuf image builded by ya buf tool
    """
    any_arch = True
    executable = False
    auto_backup = True
    calc_md5 = True
    share = True


class RtWonderlogsPackage(sdk2.Resource):
    """
    RT Wonderlogs tarball package
    """
    any_arch = True
    executable = False
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True


class LogviewerPackage(sdk2.Resource):
    """
    Logviewer tarball package
    """
    any_arch = True
    executable = False
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = vins_releasers


class YdbTableRotator(sdk2.Resource):
    """
    Binary to rotate YDB tables
    """
    any_arch = True
    executable = True
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = vins_releasers
