# -*- coding: utf-8 -*-

import sandbox.common.types.misc as ctm
import sandbox.projects.common.search.gdb as gdb

from sandbox import sdk2
from sandbox.projects.common.build.tasks import YaMakeTemplate
from sandbox.projects.voicetech.resource_types import (
    VOICETECH_ASR_SERVER,
    VOICETECH_ASR_SERVER_GPU,
    VOICETECH_ASR_NN_SERVER,
    VOICETECH_ASR_NN_SERVER_GPU,
    VOICETECH_ASR_SERVER_RUNNER,
    VOICETECH_ASR_NN_SERVER_RUNNER,
    VOICETECH_BIO_SERVER,
    VOICETECH_BIO_SERVER_RUNNER,
    VOICETECH_EVLOGDUMP,
)


_BUILD_MODE_TO_RESOURCE_MAP = {
    key: list(map(str, values))
    for key, values in {
        "ASR_SERVER": [VOICETECH_ASR_SERVER, VOICETECH_ASR_SERVER_RUNNER, VOICETECH_EVLOGDUMP],
        "ASR_SERVER_GPU": [VOICETECH_ASR_SERVER_GPU, VOICETECH_ASR_SERVER_RUNNER, VOICETECH_EVLOGDUMP],
        "NN_SERVER": [VOICETECH_ASR_NN_SERVER, VOICETECH_ASR_NN_SERVER_RUNNER, VOICETECH_EVLOGDUMP],
        "NN_SERVER_GPU": [VOICETECH_ASR_NN_SERVER_GPU, VOICETECH_ASR_NN_SERVER_RUNNER, VOICETECH_EVLOGDUMP],
        "BIO_SERVER": [VOICETECH_BIO_SERVER, VOICETECH_BIO_SERVER_RUNNER, VOICETECH_EVLOGDUMP],
    }.iteritems()
}


class BuildAsrBinaryKosher(YaMakeTemplate.YaMakeTemplate):
    class Requirements(YaMakeTemplate.YaMakeTemplate.Requirements):
        disk_space = 80000  # 80 Gb
        ram = 128 * 1000  # 128 Gb [DEVTOOLSSUPPORT-3744]

    class Parameters(YaMakeTemplate.get_project_params([
        VOICETECH_ASR_SERVER,
        VOICETECH_ASR_SERVER_GPU,
        VOICETECH_ASR_NN_SERVER,
        VOICETECH_ASR_NN_SERVER_GPU,
        VOICETECH_ASR_SERVER_RUNNER,
        VOICETECH_ASR_NN_SERVER_RUNNER,
        VOICETECH_BIO_SERVER,
        VOICETECH_BIO_SERVER_RUNNER,
        VOICETECH_EVLOGDUMP
    ])):
        with sdk2.parameters.RadioGroup('Build type') as asr_build_mode:
            for idx, name in enumerate(_BUILD_MODE_TO_RESOURCE_MAP):
                is_default = (idx == 0)
                setattr(asr_build_mode.values, name, asr_build_mode.Value(name, default=is_default))

    def on_enqueue(self):
        self.Parameters.target_resources = _BUILD_MODE_TO_RESOURCE_MAP[self.Parameters.asr_build_mode]
        if 'GPU' in self.Parameters.asr_build_mode:
            cuda_version = self.Context.cuda_version
            if cuda_version is ctm.NotExists:
                cuda_version = '10.1'
            gpu_params = '-DTENSORFLOW_WITH_CUDA -DCUDA_VERSION={} '.format(cuda_version)
            self.Parameters.definition_flags = gpu_params + self.Parameters.definition_flags
        super(BuildAsrBinaryKosher, self).on_enqueue()

    def on_execute(self):
        if '/trunk/' not in self.Context.checkout_arcadia_from_url:
            gdb.append_to_release_sdk2(self)
        super(BuildAsrBinaryKosher, self).on_execute()
