# -*- coding: utf-8 -*-

import sandbox.common.types.client as ctc
import sandbox.projects.common.constants as consts
import sandbox.projects.release_machine.mixins.build as rm_build_mixin

from sandbox.projects.common.build.CommonBuildTask import CommonBuildTask
from sandbox.projects.common.nanny import nanny
from sandbox.projects.release_machine import rm_notify
from sandbox.projects.voicetech.resource_types import VOICETECH_ASR_NN_SERVER, VOICETECH_ASR_NN_SERVER_RUNNER, \
    VOICETECH_EVLOGDUMP


@rm_notify.notify2()
class BuildAsrNNServer(rm_build_mixin.ComponentReleaseTemplate, CommonBuildTask, nanny.ReleaseToNannyTask):
    """ Build asr nn-server without CUDA
    """

    type = 'BUILD_ASR_NN_SERVER'
    execution_space = 80000  # 80 Gb
    ram = 128 * 1000  # 128 Gb [DEVTOOLSSUPPORT-3744]
    input_parameters = CommonBuildTask.input_parameters
    client_tags = ctc.Tag.Group.LINUX
    TARGET_RESOURCE_TYPES = (
        VOICETECH_ASR_NN_SERVER,
        VOICETECH_ASR_NN_SERVER_RUNNER,
        VOICETECH_EVLOGDUMP,
    )

    def on_enqueue(self):
        if '/trunk/' in self.ctx[consts.ARCADIA_URL_KEY]:
            decreased_space = 50 * 1024
            if decreased_space < self.execution_space:
                self.execution_space = decreased_space  # Decrease trunk build execution space
        CommonBuildTask.on_enqueue(self)

    def do_execute(self):
        CommonBuildTask.do_execute(self)

    def on_release(self, additional_parameters):
        nanny.ReleaseToNannyTask.on_release(self, additional_parameters)


__Task__ = BuildAsrNNServer
