# -*- coding: utf-8 -*-

import os

from sandbox.projects.voicetech import resource_types
from sandbox.projects.common.nanny import nanny
from sandbox.projects.sandbox import remote_copy_resource


class BuildYaldiRuRuNumbersLingware(remote_copy_resource.RemoteCopyResource, nanny.ReleaseToNannyTask):

    type = 'BUILD_YALDI_RU_RU_NUMBERS_LINGWARE'

    TARGET_RESOURCE_TYPES = [
        resource_types.VOICETECH_YALDI_RU_RU_NUMBERS,
    ]

    def on_release(self, additional_parameters):
        nanny.ReleaseToNannyTask.on_release(self, additional_parameters)

    def get_targets(self):
        return [resource_type.arcadia_build_path
                for resource_type in self.TARGET_RESOURCE_TYPES]

    def get_resources(self):
        resources = {}
        for resource_type in self.TARGET_RESOURCE_TYPES:
            resource = {
                'description': resource_type.name,
                'resource_type': resource_type,
                'resource_path': os.path.basename(resource_type.arcadia_build_path),
            }
            resources[resource_type.name] = resource

        return resources


__Task__ = BuildYaldiRuRuNumbersLingware
