# -*- coding: utf-8 -*-
# This task is copied from YA_MAKE2 and needs cleanup. It'll be done one day

import logging
import os
import platform
import re
import shlex
import tempfile
import traceback
from sandbox import common
from sandbox import sdk2
from sandbox.sandboxsdk import errors
from sandbox.sandboxsdk import ssh
import sandbox.common.types.client as ctc
import sandbox.common.types.task as ctt
from sandbox.projects.common import context_managers
from sandbox.projects.common import error_handlers as eh
from sandbox.projects.common import file_utils as fu
from sandbox.projects.common.arcadia import sdk
from sandbox.projects.common.build.sdk import sdk_compat as ya_sdk_compat
import sandbox.projects.common.build.parameters as build_parameters
import sandbox.projects.common.constants as consts
from sandbox.projects.common.nanny import nanny


PACK_DIR = ya_sdk_compat.PACK_DIR
ENV_VAR_PATTERN = r'^\s*(\b[a-zA-Z_]\w*=((\'[^\']*\')|(\"[^\"]*\")|([^\s\'\"]+))(\s+|$))+$'
VAULT_PATTERN = r'\$\(vault:(?P<dst>file|value):(?P<owner>[^:]+):(?P<name>[^:]+)\)'


class ArcadiaProjectBuildParameters(sdk2.Task.Parameters):
    """
    Параметры сборки, специфичные для проектов Аркадии.
    """
    build_system = build_parameters.BuildSystem(default_value=consts.SEMI_DISTBUILD_BUILD_SYSTEM)
    build_type = build_parameters.BuildType()
    checkout = build_parameters.CheckoutParameter()
    checkout_mode = build_parameters.CheckoutModeParameter()
    clear_build = build_parameters.ClearBuild()
    definition_flags = build_parameters.DefinitionFlags()
    env_vars = build_parameters.EnvironmentVarsParam()
    force_build_depends = build_parameters.ForceBuildDepends()
    force_vcs_info_update = build_parameters.ForceVCSInfoUpdate()
    ignore_recurses = build_parameters.IgnoreRecurses()

    strip_binaries = build_parameters.StripBinaries()

    vault_key_name = build_parameters.VaultKeyName()
    vault_owner = build_parameters.VaultOwner()
    ya_timeout = build_parameters.YaTimeout()

    debug_specific_parameters = build_parameters.DebugSpecificParameters()


class ContainerParameter(sdk2.parameters.Container):
    name = "sandbox_container"
    description = 'Container the task should execute in'
    default_value = None
    required = False


class SandboxTaskParameters(sdk2.Task.Parameters):
    sandbox_container = ContainerParameter()
    with sdk2.parameters.Group("Sandbox parameters:"):
        sandbox_tags = sdk2.parameters.String("Sandbox task tags. Doc: https://nda.ya.ru/3RhRAc", default="GENERIC")
        privileged = sdk2.parameters.Bool("Should run tasks under root privileges", default=False, required=False)


class BuildVoicetechBinary(sdk2.Task, nanny.ReleaseToNannyTask2):
    build_output_html_ttl = 7
    build_output_ttl = 7

    class Requirements(sdk2.Task.Requirements):
        # build tree + resources quota + arcadia and partial arcadia_tests_data cache
        disk_space = 10 * 1024 + 10 * 1024 + (10 + 10) * 1024  # in Mb

        client_tags = ctc.Tag.LINUX_XENIAL & ctc.Tag.GENERIC  # XENIAL is used in prod

    class Parameters(sdk2.Task.Parameters):
        result_rd = sdk2.parameters.String("Result resource description", default="Voicetech binary")
        arcadia_parameters = build_parameters.ArcadiaParameters()
        arcadia_project_build_parameters = ArcadiaProjectBuildParameters()
        sandbox_task_parameters = SandboxTaskParameters()

        use_aapi_fuse = build_parameters.UseArcadiaApiFuse(default_value=True)
        use_arc_instead_of_aapi = build_parameters.UseArcInsteadOfArcadiaApi(default_value=False)
        aapi_fallback = build_parameters.AllowArcadiaApiFallback(default_value=True)

    class Context(sdk2.Context):
        pass

    def abs_path(self, *args):
        settings = common.config.Registry()
        local_path = os.path.join(*(ctt.relpath(self.id) + map(str, args)))
        return os.path.join(settings.client.tasks.data_dir, local_path)

    def pre_execute(self):
        checkout_arcadia_from_url = self.Parameters.checkout_arcadia_from_url
        try:
            checkout_arcadia_from_url = sdk2.svn.Arcadia.freeze_url_revision(checkout_arcadia_from_url)
        except sdk2.svn.SvnError as e:
            eh.fail('Arcadia URL {0} does not exist. Error: {1}'.format(checkout_arcadia_from_url, e))

        parsed_url = sdk2.svn.Arcadia.parse_url(checkout_arcadia_from_url)
        self.Context.ap_arcadia_revision = parsed_url.revision
        self.Context.ap_arcadia_trunk = parsed_url.trunk
        self.Context.ap_arcadia_branch = parsed_url.branch
        self.Context.ap_arcadia_tag = parsed_url.tag
        self.Context.checkout_arcadia_from_url = checkout_arcadia_from_url

    def get_arcadia_src_dir(self, copy_trunk=False):
        return sdk2.svn.Arcadia.get_arcadia_src_dir(
            self.Context.checkout_arcadia_from_url,
            copy_trunk=copy_trunk,
        )

    def deref(self, s):
        def deref_vault(match):
            secret = sdk2.Vault.data(match.group('owner'), match.group('name'))
            if match.group('dst') == 'file':
                deref_path = tempfile.NamedTemporaryFile().name
                fu.write_file(deref_path, secret)
                return deref_path
            return secret
        s = re.sub(VAULT_PATTERN, deref_vault, s)
        return s

    def get_env_vars(self):
        env_vars = self.Parameters.env_vars
        if env_vars and not re.match(ENV_VAR_PATTERN, env_vars):
            eh.check_failed("Incorrect 'Environment variables' parameter '{}'".format(env_vars))
        env_vars = {k: self.deref(v) for k, v in (x.split('=', 1) for x in shlex.split(env_vars))}
        if 'GSID' not in env_vars.keys() and 'GSID' in os.environ.keys():
            env_vars['GSID'] = os.getenv('GSID')
        return env_vars

    def get_targets(self):
        return [os.path.dirname(self.RESOURCE_TYPE.arcadia_build_path)]

    def get_arts(self):
        """ Returns built artifact """
        return [{"path": self.RESOURCE_TYPE.arcadia_build_path}]

    def check_aapi_available(self):
        return ya_sdk_compat.check_aapi_available(self)

    def on_enqueue(self):
        self.ramdrive = None

        resource_path = os.path.join(PACK_DIR, os.path.basename(self.RESOURCE_TYPE.arcadia_build_path)).rstrip(os.sep)
        self.Context.resource_id = sdk2.Resource[self.RESOURCE_TYPE.name](
            task=self,
            description=self.Parameters.result_rd,
            path=resource_path,
        ).id

        try:
            self.Requirements.client_tags &= ctc.Tag.Query.cast(self.Parameters.sandbox_tags)
        except Exception:  # FIXME
            pass

    def on_execute(self):
        build_system = self.Parameters.build_system
        clear_build = self.Parameters.clear_build
        build_type = self.Parameters.build_type
        resource_id = self.Context.resource_id

        build_def_flags = self.Parameters.definition_flags
        if "-DNO_SRCLINK" not in build_def_flags:
            build_def_flags += " -DNO_SRCLINK=yes"

        self.pre_execute()
        build_path, output_dir = ya_sdk_compat.get_build_path(self)
        self.Context.output_dir_path = output_dir

        # Создаем директории build (для сборки) и room (для эмуляции корня arc).
        room_dir = sdk2.paths.make_folder('room')
        pack_dir = sdk2.paths.make_folder(PACK_DIR)
        source_dir = os.path.join(room_dir, 'arcadia')
        self.Context.source_dir = source_dir

        # Вычисляем дополнительные опции сборки.
        patch = self.Parameters.arcadia_patch

        checkout, mode = ya_sdk_compat.check_parameters_compatibility(self, make_context_on_distbuild=False)
        self.Context.checkout = checkout
        self.Context.mode = mode

        arcadia_ctx, arcadia_tests_data_ctx = ya_sdk_compat.get_source_dirs(self, mode)
        with arcadia_ctx as arcadia_path, arcadia_tests_data_ctx as arcadia_tests_data:
            logging.info("Arcadia source dir: %s", arcadia_path)
            logging.info("Arcadia tests data source dir: %s", arcadia_tests_data)

            ya_sdk_compat.ensure_link(arcadia_path, source_dir)

            # Set YA_SOURCE_ROOT env to avoid ya respawn after symlink creation
            os.environ["YA_SOURCE_ROOT"] = source_dir

            if patch:
                logging.info("Apply patches...")
                sdk.apply_patch(self, source_dir, patch, self.abs_path(), checkout)

            targets = self.get_targets()
            arts = self.get_arts()
            logging.debug('Targets are %s, artifacts are %s', targets, arts)

            vault_owner = getattr(self.Parameters, consts.VAULT_OWNER, self.author)
            vault_key_name = getattr(self.Parameters, consts.VAULT_KEY_NAME)
            tests_requested = getattr(self.Parameters, consts.TESTS_REQUESTED, False)

            # Выкачиваем и обновляем нужное поддерево ATD
            if tests_requested and (arcadia_tests_data is None):
                logging.debug(
                    'update_atd %s, %s, %s, %s, %s, False',
                    checkout, source_dir, targets, clear_build, build_system,
                )
                arcadia_tests_data = ya_sdk_compat.update_atd(
                    self, checkout, source_dir, targets, clear_build, build_system, False
                )
                logging.debug('arcadia_tests_data = {}'.format(arcadia_tests_data))

            build_output_res = sdk2.Resource["BUILD_OUTPUT"](
                self,
                description="Build output",
                path=output_dir,
                ttl=self.build_output_ttl
            )

            try:
                if vault_owner and vault_key_name:
                    ssh_manager = ssh.Key(self, vault_owner, vault_key_name)
                    logging.debug("Use SSH with a key from vault {}@{}".format(vault_owner, vault_key_name))
                else:
                    ssh_manager = context_managers.nullcontext()
                    logging.debug("No SSH context")

                with ssh_manager:
                    env = self.get_env_vars()
                    env["YA_DUMP_RAW_RESULTS"] = "1"
                    logging.debug("Start do_build")
                    sdk.do_build(
                        build_system,
                        source_dir,
                        targets,
                        build_resource_id=build_output_res.id,
                        build_type=build_type,
                        clear_build=clear_build,
                        def_flags=build_def_flags,
                        results_dir=output_dir,
                        # target_platform=self.Parameters.target_platform,
                        # add_result=[suffix for suffix in self.Parameters.ya_add_result if suffix],  # TODO: remove filter after SANDBOX-6065
                        # strip_binaries=strip_binaries,
                        test=True,
                        # test_filters=getattr(self.Parameters, consts.TEST_FILTERS),
                        # output_only_tests=getattr(self.Parameters, consts.OUTPUT_ONLY_TESTS, False),ya
                        # junit_report_path=junit_report_path,
                        # use_dev_version=use_dev_version, timeout=timeout, coverage=coverage,
                        # coverage_prefix_filter=coverage_prefix_filter,
                        # coverage_exclude_regexp=coverage_exclude_regexp, sanitize=sanitize,
                        # coverage_unified_agent=coverage_unified_agent, coverage_unified_agent_sid=coverage_unified_agent_sid, coverage_unified_agent_strict=coverage_unified_agent_strict,
                        # coverage_unified_agent_uids_res_id=getattr(self.Parameters, consts.COVERAGE_UNIFIED_AGENT_UIDS_RESOURCE_ID, None),
                        # coverage_unified_agent_uids_file_path=getattr(self.Parameters, consts.COVERAGE_UNIFIED_AGENT_UIDS_FILE_PATH, None),
                        # test_params=test_params,
                        # report_tests_only=getattr(self.Parameters, consts.REPORT_TESTS_ONLY),
                        # test_log_level=getattr(self.Parameters, consts.TEST_LOG_LEVEL),
                        # test_tag=getattr(self.Parameters, consts.TEST_TAG),
                        # allure_report=allure_report,
                        # allure_report_ttl=allure_report_ttl,
                        # disable_test_timeout=getattr(self.Parameters, consts.DISABLE_TEST_TIMEOUT),
                        # force_build_depends=getattr(self.Parameters, consts.FORCE_BUILD_DEPENDS),
                        # force_vcs_info_update=getattr(self.Parameters, consts.FORCE_VCS_INFO_UPDATE, False),
                        # ignore_recurses=getattr(self.Parameters, consts.IGNORE_RECURSES),
                        # patch=patch,
                        # test_size_filter=test_size_filter,
                        # test_threads=getattr(self.Parameters, consts.TEST_THREADS),
                        # arcadia_tests_data=arcadia_tests_data,
                        # cache_test_results=getattr(self.Parameters, consts.CACHE_TEST_RESULTS),
                        # tests_retries=getattr(self.Parameters, consts.TESTS_RETRIES),
                        # test_type_filter=test_type_filter,
                        # checkout=checkout,
                        # fuzzing=getattr(self.Parameters, consts.FUZZING, None),
                        # fuzz_opts=fuzz_opts,
                        # sanitize_coverage=sanitize_coverage,
                        # cache_namespace=cache_namespace,
                        # sandbox_token=sandbox_token,
                        # ssh_user=vault_owner,
                        # no_src_changes=getattr(self.Parameters, consts.NO_SRC_CHANGES, True),
                        # resource_owner=getattr(self.Parameters, consts.RESOURCE_OWNER, None),
                        # streaming_link=getattr(self.Parameters, consts.STREAMING_REPORT_URL, None),
                        # streaming_check_id=getattr(self.Parameters, consts.STREAMING_REPORT_ID, None),
                        # collect_test_cores=getattr(self.Parameters, consts.COLLECT_TEST_CORES, True),
                        # sonar=getattr(self.Parameters, consts.SONAR, False),
                        # sonar_options=getattr(self.Parameters, consts.SONAR_OPTIONS, None),
                        # sonar_project_filter=getattr(self.Parameters, consts.SONAR_PROJECT_FILTER, None),
                        # sonar_default_project_filter=getattr(self.Parameters, consts.SONAR_DEFAULT_PROJECT_FILTER, False),
                        # java_coverage=java_coverage,
                        # sandbox_uploaded_resource_ttl=getattr(self.Parameters, consts.SANDBOX_UPLOADED_RESOURCE_TTL, None),
                        # multiplex_ssh=getattr(self.Parameters, consts.MULTIPLEX_SSH, False),
                        # build_execution_time=getattr(self.Parameters, consts.BUILD_EXECUTION_TIME, None),
                        # cpp_coverage_type=getattr(self.Parameters, consts.CPP_COVERAGE_TYPE, None),
                        # python_coverage=getattr(self.Parameters, consts.PYTHON_COVERAGE, False),
                        # go_coverage=getattr(self.Parameters, consts.GO_COVERAGE, False),
                        # upload_coverage=getattr(self.Parameters, consts.UPLOAD_COVERAGE, False),
                        # merge_coverage=getattr(self.Parameters, consts.MERGE_COVERAGE, False),
                        # graph_timestamp=getattr(self.Parameters, consts.GRAPH_TIMESTAMP, None),
                        # download_artifacts=getattr(self.Parameters, consts.DOWNLOAD_ARTIFACTS_FROM_DISTBUILD, True),
                        # drop_graph_result_before_tests=getattr(self.Parameters, consts.DROP_GRAPH_RESULT_BEFORE_TESTS, False),
                        # save_links_for_files=save_links_for_files,
                        # javac_options=getattr(self.Parameters, consts.JAVAC_OPTIONS, None),
                        # jvm_args=getattr(self.Parameters, consts.JVM_ARGS_KEY, None),
                        # strip_skipped_test_deps=getattr(self.Parameters, consts.STRIP_SKIPPED_TEST_DEPS, False),
                        # coordinators_filter=getattr(self.Parameters, consts.COORDINATORS_FILTER, None),
                        # separate_result_dirs=getattr(self.Parameters, consts.SEPARATE_RESULT_DIRS, False),
                        # fast_clang_coverage_merge=getattr(self.Parameters, consts.FAST_CLANG_COVERAGE_MERGE, False),
                        # new_dist_mode=getattr(self.Parameters, consts.NEW_DIST_MODE, False),
                        # skip_test_console_report=getattr(self.Parameters, consts.SKIP_TEST_CONSOLE_REPORT, False),
                        build_output_html_ttl=self.build_output_html_ttl,
                        # keep_alive_all_streams=getattr(self.Parameters, consts.KEEP_ALIVE_ALL_STREAMS, False),
                        # trace_ya_output=getattr(self.Parameters, consts.TRACE_YA_OUTPUT, False),
                        # env=env,
                        # dir_outputs=getattr(self.Parameters, consts.DIR_OUTPUTS, False)
                    )
            except (common.errors.TemporaryError, errors.SandboxSubprocessTimeoutError) as err:
                logging.debug(traceback.format_exc())
                raise err
            except Exception as err:
                logging.debug(traceback.format_exc())
                raise err
            finally:
                try:
                    from sandbox.sandboxsdk import process
                    p = process.run_process(["chmod", "--recursive", "755", output_dir], log_prefix='chmod_output_dir')
                    p.communicate()
                except Exception as e:
                    logging.error("Error while chmod: %s", e)

                # Упаковываем артефакты до того как ресурс помечается как ready
                logging.debug('go pack arts: arts {}, pack_dir {}, output_dir {}'.format(arts, pack_dir, output_dir))
                ya_sdk_compat.pack_arts(arts, pack_dir, output_dir)
                sdk2.ResourceData(build_output_res).ready()

            # finalize resource
            self._set_resource_attributes(resource_id, {
                "arcadia_revision": self.Context.ap_arcadia_revision,
                "arcadia_trunk": self.Context.ap_arcadia_trunk,
                "arcadia_branch": self.Context.ap_arcadia_branch,
                "arcadia_tag": self.Context.ap_arcadia_tag,
                "build_platform": platform.platform(),
                "build_tool": build_system,
                "build_type": build_type
            })
            sdk2.ResourceData(sdk2.Resource[resource_id]).ready()
            logging.info("Resource is ready")

            if self.Context.exceptions:
                eh.check_failed('FORCE_FAILURE: Delayed exceptions found, see logs above')

    def on_release(self, additional_parameters):
        nanny.ReleaseToNannyTask2.on_release(self, additional_parameters)
        sdk2.Task.on_release(self, additional_parameters)

    def _set_resource_attributes(self, resource_id, attrs):
        r = self.server.resource[resource_id]
        for name, value in attrs.iteritems():
            if value is None:
                continue
            try:
                r.attribute(name=name, value=value)
                logging.debug("Set attribute on {} resource: {}={}".format(resource_id, name, value))
            except AttributeError as err:
                logging.warning("Failed to set attribute on %s resource: %s=%s (%s)", resource_id, name, value, err)
