# coding: utf-8
from sandbox.sandboxsdk import parameters
from sandbox.projects.common.nanny import nanny
from sandbox.projects.common.build import YaPackage
import sandbox.projects.common.build.parameters as build_parameters


class BuildVoicetechPackage(YaPackage.YaPackage, nanny.ReleaseToNannyTask):
    """ Base class for tasks to create voicetech packages
    """

    type = "BUILD_VOICETECH_PACKAGE"

    RESOURCE_TYPE = None  # must be defined in subclasses

    input_parameters = (
        parameters.SandboxArcadiaUrlParameter,
        build_parameters.BuildType,
        build_parameters.ArcadiaPatch,

        YaPackage.parameters.UseArcadiaApiFuse,
        YaPackage.parameters.UseArcInsteadOfArcadiaApi,
        YaPackage.parameters.AllowArcadiaApiFallback,
        YaPackage.parameters.ArcSecret,

        YaPackage.TestsBlock,
        # Tests
        YaPackage.RunTestsParameter,
        YaPackage.RunMediumTestsParameter,
        YaPackage.RunLongTestsParameter,
        YaPackage.IgnoreFailTestsParameter,
    )

    required_ram = 16 * 1024     # 16 Gb
    execution_space = 50 * 1024  # 50 Gb

    def on_enqueue(self):
        if self.RESOURCE_TYPE is None:
            raise AttributeError("RESOURCE_TYPE class memeber must be defined")
        if not hasattr(self.RESOURCE_TYPE, "package_path"):
            raise AttributeError("Resource type MUST contain 'package_path' attribute")

        input_parameters_names = set(parameter.name for parameter in self.input_parameters)
        for parameter in YaPackage.YaPackage.input_parameters:
            if parameter.name not in input_parameters_names:
                self.ctx[parameter.name] = parameter().default_value

        if hasattr(self.RESOURCE_TYPE, "package_mode"):
            mode = self.RESOURCE_TYPE.package_mode.lower()
            self.ctx.update({
                YaPackage.RawPackageParameter.name: "tar" not in mode,
                YaPackage.CompressPackageArchiveParameter.name: "gz" in mode
            })

        self.ctx.update({
            YaPackage.PackageTypeParameter.name: YaPackage.TARBALL,
            YaPackage.PublishPackageParameter.name: False,
            YaPackage.PackagesParameter.name: self.RESOURCE_TYPE.package_path,
            YaPackage.ResourceTypeParameter.name: self.RESOURCE_TYPE.name,
            build_parameters.CheckoutModeParameter.name: "auto"
        })

        YaPackage.YaPackage.on_enqueue(self)

    def on_release(self, additional_parameters):
        nanny.ReleaseToNannyTask.on_release(self, additional_parameters)
