# -*- coding: utf-8 -*-
from sandbox import sdk2
from sandbox.projects.release_machine.components import all as rmc
from sandbox.projects.release_machine.core import const as rm_const
from sandbox.projects.release_machine.core import task_env
from sandbox.projects.release_machine.helpers.startrek_helper import STHelper


class VoiceGetReleaseTicket(sdk2.Task):
    class Requirements(sdk2.Task.Requirements):
        environments = [task_env.TaskRequirements.startrek_client]
        client_tags = task_env.TaskTags.startrek_client

    class Parameters(sdk2.Task.Parameters):
        component_name = sdk2.parameters.String('Component name', default='asr_server', required=True)
        release_number = sdk2.parameters.Integer('Release number', required=True)

        with sdk2.parameters.Output:
            release_ticket = sdk2.parameters.String("Release ticket", required=True)

    def on_execute(self):
        c_info = rmc.COMPONENTS[self.Parameters.component_name]()
        st_helper = STHelper(sdk2.Vault.data(rm_const.COMMON_TOKEN_OWNER, rm_const.COMMON_TOKEN_NAME))
        issue = st_helper.find_ticket_by_release_number(self.Parameters.release_number, c_info)
        self.Parameters.release_ticket = issue.key
