# -*- coding: utf-8 -*-

import logging
import os
import requests


def post_comment(comment_text, ticket_target, robot_st_token, summonees=None):
    content = {
        'text': comment_text,
    }
    if summonees is not None:
        content['summonees'] = summonees
    custom_headers = {
        'Accept': 'application/json',
        'Authorization': 'OAuth ' + robot_st_token,
        'Content-Type': 'application/json',
    }
    target = 'https://st-api.yandex-team.ru/v2/issues/{}/comments'.format(ticket_target)
    logging.debug('try add comment to {}'.format(ticket_target))
    r = requests.post(
        target,
        json=content,
        headers=custom_headers,
    )
    logging.debug('add comment response code={}'.format(r.status_code))
    if r.status_code / 100 != 2:
        raise Exception('fail add Startrack comment: response code={} text={}'.format(r.status_code, r.text.encode('utf-8')))


if __name__ == "__main__":
    root_logger = logging.getLogger('')
    out_logger = logging.StreamHandler()
    out_logger.setFormatter(logging.Formatter('%(asctime)s %(levelname)-8s %(filename)s:%(lineno)d %(message)s'))
    root_logger.addHandler(out_logger)
    root_logger.setLevel(logging.DEBUG)

    user_token = os.getenv('STARTRACK_TOKEN')
    if not user_token:
        logging.info('not found env. var. STARTRACK_TOKEN, try read token from ~/.startrack-token')
        with open(os.path.join(os.getenv('HOME'), '.startrack-token')) as f:
            user_token = f.read().strip()
    if not user_token:
        raise Exception('can not work without nirvana token (use env.var. or ~/.nirvana-token file)')

    logging.info('got token')

    #
    # code for debug (+trivial example)
    #
    post_comment('test/debug sandbox/projects/voicetech/common/startrack.py', 'ALICERELEASE-1', user_token)
